<?php
error_reporting(E_ALL);
ini_set('display_errors','0');
ini_set('log_errors','1');
ini_set('error_log', __DIR__ . '/php_error.log');

header('Content-Type: application/json');
require 'config.php';

try {
    $school_id = trim($_POST['school_id']   ?? '');
    $name      = trim($_POST['book']   ?? '');
    $author    = trim($_POST['author'] ?? '');
    $type      = trim($_POST['type']   ?? '');
    $stock     = intval($_POST['stock'] ?? 0);
    $des       = trim($_POST['des']    ?? '');

    if (!$school_id) {
        throw new Exception('School id is not provided, maybe session has expired!');
    }
    if (!$name || !$author || !$type || $stock < 1 || empty($_FILES['image']['tmp_name'])) {
        throw new Exception('All required fields must be filled and stock ≥1.');
    }

    $stmt = $pdo->prepare("SELECT id FROM book_category WHERE name = ?");
    $stmt->execute([$type]);
    $cat = $stmt->fetchColumn();
    if (!$cat) {
        $stmt = $pdo->prepare("INSERT INTO book_category (name) VALUES (?)");
        $stmt->execute([$type]);
        $cat = $pdo->lastInsertId();
    }

    $bookDir = __DIR__ . '/uploads/books/';
    if (!is_dir($bookDir) && !mkdir($bookDir, 0777, true)) {
        throw new Exception("Cannot create directory: $bookDir");
    }
    $img      = $_FILES['image'];
    $ext      = strtolower(pathinfo($img['name'], PATHINFO_EXTENSION));
    $bookImg  = uniqid('book_', true) . '.' . $ext;
    $bookDest = $bookDir . $bookImg;
    if (!is_uploaded_file($img['tmp_name']) ||
        !move_uploaded_file($img['tmp_name'], $bookDest)
    ) {
        throw new Exception('Book cover upload failed.');
    }

    $stmt = $pdo->prepare("INSERT INTO books (cat_id, school_id, name, author, stock, des, image) VALUES (:cat, :school, :name, :author, :stock, :des, :img)");
    $stmt->execute([
      ':cat'    => $cat,
      ':school' => $school_id,
      ':name'   => $name,
      ':author' => $author,
      ':stock'  => $stock,
      ':des'    => $des,
      ':img'    => 'uploads/books/' . $bookImg
    ]);
    $book_id = $pdo->lastInsertId();

    $qrDir = __DIR__ . '/uploads/book_qr/';
    if (!is_dir($qrDir) && !mkdir($qrDir, 0777, true)) {
        throw new Exception("Cannot create directory: $qrDir");
    }

    for ($i = 1; $i <= $stock; $i++) {
        $copyCode = $book_id . '-' . str_pad($i, 4, '0', STR_PAD_LEFT); 

        $qrFile = "qr_{$copyCode}.png";
        $qrPath = $qrDir . $qrFile;
        $apiUrl = 'https://api.qrserver.com/v1/create-qr-code/' . '?data=' . urlencode($copyCode) . '&size=200x200';

        $ch = curl_init($apiUrl);
        curl_setopt_array($ch, [
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_TIMEOUT        => 10,
        ]);
        $qrData = curl_exec($ch);
        $err    = curl_error($ch);
        curl_close($ch);

        if ($err || !$qrData) {
            throw new Exception("Failed to generate QR for {$copyCode}: {$err}");
        }
        file_put_contents($qrPath, $qrData);

        $stmt = $pdo->prepare("INSERT INTO book_copies (book_id, copy_code, code_type, code_image) VALUES (:book, :code, 'QR', :img)");
        $stmt->execute([
          ':book' => $book_id,
          ':code' => $copyCode,
          ':img'  => 'uploads/book_qr/' . $qrFile
        ]);
    }

    echo json_encode([
      'status'  => 'success',
      'message' => "Book + {$stock} QR codes saved!"
    ]);

} catch (Exception $e) {
    error_log("add_book.php Error: " . $e->getMessage());
    echo json_encode([
      'status'  => 'error',
      'message' => $e->getMessage()
    ]);
} ?>