<?php

ini_set('display_errors', '1');
error_reporting(E_ALL);

header('Content-Type: application/json');
require '../config.php';

if (isset($_GET['school'])) {
    $school = $_GET['school'];
} else {
    session_start();
    $school = isset($_SESSION['school']) ? $_SESSION['school'] : '';
}
$result = [];

$tkstmt = $pdo->prepare("SELECT id, token FROM listed_school WHERE school = :school LIMIT 1");
$tkstmt->execute([
    ':school' => $school
]);
$schoolData = $tkstmt->fetch();
$schoolToken = $schoolData ? $schoolData['token'] : '';
$schoolId = $schoolData ? $schoolData['id'] : '';

$stmt = $pdo->prepare("SELECT id, name FROM departments WHERE school_id = ? ORDER BY name");
$stmt->execute([$schoolId]);
$departments = $stmt->fetchAll();

foreach ($departments as $dept) {
    $d = ['id' => $dept['id'], 'name' => $dept['name'], 'classes' => []];
    
    // get classes
    $stmt2 = $pdo->prepare("SELECT id, name FROM classes WHERE department_id = ? ORDER BY name");
    $stmt2->execute([$dept['id']]);
    $classes = $stmt2->fetchAll();
    foreach ($classes as $cls) {
        $c = ['id' => $cls['id'], 'name' => $cls['name'], 'sections' => []];
        
        // get sections
        $stmt3 = $pdo->prepare("SELECT id, name FROM sections WHERE class_id = ? ORDER BY name");
        $stmt3->execute([$cls['id']]);
        $sections = $stmt3->fetchAll();
        
        // for just-class (no section)
        $studentsStmt = $pdo->prepare("SELECT * FROM students_temp WHERE status='Assigned' AND school_token=? AND department_id=? AND class_id=? AND (section_id IS NULL OR section_id=0) ORDER BY roll_no");
        $studentsStmt->execute([$schoolToken, $dept['id'], $cls['id']]);
        $c['students'] = $studentsStmt->fetchAll();
        
        // fetch a teacher assignment if any
        $teacherStmt = $pdo->prepare("SELECT t.id, t.name FROM class_teachers ct JOIN teachers t ON ct.teacher_id=t.id WHERE ct.department_id=? AND ct.class_id=? AND ct.section_id IS NULL");
        $teacherStmt->execute([$dept['id'], $cls['id']]);
        $c['teacher'] = $teacherStmt->fetch() ?: null;
        
        // sections loop
        foreach ($sections as $sec) {
            $s = ['id' => $sec['id'], 'name' => $sec['name']];
            // students in section
            $secStmt = $pdo->prepare("SELECT * FROM students_temp WHERE status='Assigned' AND school_token=? AND department_id=? AND class_id=? AND section_id=? ORDER BY roll_no");
            $secStmt->execute([$schoolToken, $dept['id'], $cls['id'], $sec['id']]);
            $s['students'] = $secStmt->fetchAll();
            // teacher
            $tStmt = $pdo->prepare("SELECT t.id, t.name FROM class_teachers ct JOIN teachers t ON ct.teacher_id=t.id WHERE ct.department_id=? AND ct.class_id=? AND ct.section_id=?");
            $tStmt->execute([$dept['id'], $cls['id'], $sec['id']]);
            $s['teacher'] = $tStmt->fetch() ?: null;
            $c['sections'][] = $s;
        }
        
        $d['classes'][] = $c;
    }
    $result[] = $d;
}

$teachStmt = $pdo->prepare("SELECT id, name FROM teachers WHERE school=? AND position='Class Teacher' ORDER BY name");
$teachStmt->execute([$schoolId]);
$teachers = $teachStmt->fetchAll();

echo json_encode(['departments' => $result, 'teachers' => $teachers]); ?>