<?php
session_start();
if(empty($_SESSION['id'])){ echo '<script>window.location.href="signin.php"</script>'; }
include "config.php";
include 'headerlink.php'; ?>

<style>
    .card-modern { border-radius: 12px; box-shadow: 0 6px 20px rgba(20,20,30,0.06); }
    .field-icon { cursor: pointer; }
    .otp-input { width: 56px; height:56px; text-align:center; font-size:24px; border-radius:8px; border:1px solid #e3e7ee; }
    .otp-row { gap:10px; }
    .match-ind { font-size:12px; }
</style> 

    <div id="main-wrapper" class="wallet-open active">
	
        <!--Nav header-->
        <div class="nav-header">
            <a href="dashboard.php" class="brand-logo">
				<!-- <svg class="logo-abbr" width="40" height="40" viewBox="0 0 48 54" fill="none" xmlns="http://www.w3.org/2000/svg">
					<rect y="3" width="48" height="48" rx="16" fill="#FB7D5B"></rect>
					<path d="M28.964 35.536H19.532L18.02 40H11.576L20.72 14.728H27.848L36.992 40H30.476L28.964 35.536ZM27.38 30.784L24.248 21.532L21.152 30.784H27.38Z" fill="white"></path>
				</svg> -->
				<div class="brand-title">
					<h4 class="fw-bold text-white">Kolkata Dealer</h4>
				</div> 
            </a>
            <div class="nav-control">
                <div class="hamburger">
                    <span class="line"></span><span class="line"></span><span class="line"></span>
					<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
						<rect x="22" y="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="11" y="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="11" y="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect y="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="22" y="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect y="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
					</svg>		
                </div>
            </div>
        </div>
        <!--/Nav header-->
		
		<!-- header -->
		<div class="header">
			<div class="header-content">
				<nav class="navbar navbar-expand">
					<div class="collapse navbar-collapse justify-content-between">
						<div class="header-left">
							<div class="dashboard_bar">Change Password</div>
						</div>
						<?php include "header.php"; ?>
					</div>
				</nav>
			</div>
		</div>
		<!-- /header -->
		<?php include "sidebar.php"; ?>
		

        <!--Content body-->
		<div class="content-body">
			<div class="container-fluid">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="card card-modern p-5">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h5 class="mb-0">Change Password</h5>
                                <small class="text-muted">Account: <?= htmlspecialchars($_SESSION['email'] ?? '') ?></small>
                            </div>
                            <div class="mb-3">
                                <div class="btn-group" role="group">
                                    <button id="mode_current" class="btn btn-outline-primary active">Use Current Password</button>
                                    <button id="mode_forgot" class="btn btn-outline-secondary">Forgot Password?</button>
                                </div>
                            </div>
                            <form id="passwordForm" novalidate>
                                <input type="hidden" id="teacher_id" name="teacher_id" value="<?= $adminId ?>">
                                <!-- CURRENT PASSWORD MODE -->
                                <div id="panel_current">
                                    <div class="mb-3">
                                        <label class="form-label">Existing Password</label>
                                        <div class="input-group">
                                            <input type="password" id="current_password" name="current_password" class="form-control" placeholder="Enter existing password" required>
                                            <span class="input-group-text field-icon" id="toggleCurrent"><i class="bi bi-eye-slash"></i></span>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">New Password</label>
                                        <div class="input-group">
                                            <input type="password" id="new_password" name="new_password" class="form-control" placeholder="New password" required>
                                            <span class="input-group-text field-icon" id="toggleNew"><i class="bi bi-eye-slash"></i></span>
                                        </div>
                                        <div class="form-text match-ind" id="matchHint_current"></div>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Confirm New Password</label>
                                        <div class="input-group">
                                            <input type="password" id="confirm_password" name="confirm_password" class="form-control" placeholder="Confirm new password" required>
                                            <span class="input-group-text field-icon" id="toggleConfirm"><i class="bi bi-eye-slash"></i></span>
                                        </div>
                                    </div>
                                    <div class="d-flex justify-content-end">
                                        <button id="btnChangeDirect" type="button" class="btn btn-primary px-4">Save Changes</button>
                                    </div>
                                </div>
                                <!-- FORGOT PASSWORD MODE -->
                                <div id="panel_forgot" style="display:none;">
                                    <div class="mb-3">
                                        <label class="form-label">Registered Email</label>
                                        <input type="email" id="fp_email" name="fp_email" class="form-control" placeholder="Enter your registered email" required>
                                    </div>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <small class="text-muted">We'll send a 4-digit OTP to your registered email.</small>
                                        <button id="btnSendOTP" type="button" class="btn btn-outline-primary">Send OTP</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!-- otp modal -->
                <div class="modal fade" id="otpModal" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content card-modern p-3">
                            <div class="modal-header border-0">
                                <h5 class="modal-title">Enter OTP</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <div class="alert alert-info small mb-3">An OTP has been sent to your registered email. It may take a few minutes to arrive — check spam if you don't see it.</div>
                                <div class="d-flex justify-content-center mb-3 otp-row">
                                    <input maxlength="1" inputmode="numeric" class="form-control otp-input" id="otp_1">
                                    <input maxlength="1" inputmode="numeric" class="form-control otp-input" id="otp_2">
                                    <input maxlength="1" inputmode="numeric" class="form-control otp-input" id="otp_3">
                                    <input maxlength="1" inputmode="numeric" class="form-control otp-input" id="otp_4">
                                </div>
                                <div class="d-flex justify-content-between">
                                    <button id="btnResendOtp" type="button" class="btn btn-link">Resend</button>
                                    <div>
                                        <button id="btnVerifyOtp" type="button" class="btn btn-primary">Verify</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /otp modal -->

                <!-- new password modal after otp verification -->
                <div class="modal fade" id="newPassModal" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content card-modern p-3">
                            <div class="modal-header border-0">
                                <h5 class="modal-title">Set New Password</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <form id="resetForm" novalidate>
                                    <div class="mb-3">
                                        <label class="form-label">New Password</label>
                                        <div class="input-group">
                                            <input type="password" id="reset_new" name="reset_new" class="form-control" placeholder="New password" required>
                                            <span class="input-group-text field-icon" id="toggleResetNew"><i class="bi bi-eye-slash"></i></span>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Confirm Password</label>
                                        <div class="input-group">
                                            <input type="password" id="reset_confirm" name="reset_confirm" class="form-control" placeholder="Confirm password" required>
                                            <span class="input-group-text field-icon" id="toggleResetConfirm"><i class="bi bi-eye-slash"></i></span>
                                        </div>
                                        <div class="form-text match-ind" id="matchHint_reset"></div>
                                    </div>
                                    <div class="d-flex justify-content-end">
                                        <button id="btnResetPassword" type="button" class="btn btn-primary">Save</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /new password modal after otp verification -->

                <!-- forced logout modal -->
                <div class="modal fade" id="logoutModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content card-modern p-3">
                            <div class="modal-header border-0"><h5 class="modal-title">Password Update Notification</h5></div>
                            <div class="modal-body">
                                <div class="d-flex justify-content-center mb-4">
                                    <i class="bi bi-shield-lock-fill text-secondary" style="font-size: 4rem;"></i>
                                </div>
                                <p class="text-center">Your password has been successfully updated. For enhanced security, please log out and log back in.</p>
                                <div class="d-flex justify-content-center mt-4">
                                    <a id="confirmSignout" href="signout.php" class="btn btn-danger">Log out</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /forced logout modal -->
			</div>
		</div>

		<?php include "footer.php" ?>

	</div>
    
<!-- All necessary scripts are here -->
<script>
    $(function(){
        var otpModal = new bootstrap.Modal(document.getElementById('otpModal'));
        var newPassModal = new bootstrap.Modal(document.getElementById('newPassModal'));
        var logoutModal = new bootstrap.Modal(document.getElementById('logoutModal'));

        $('#mode_current').on('click', function(){
            $('#mode_current').addClass('active btn-primary').removeClass('btn-outline-primary');
            $('#mode_forgot').removeClass('active btn-secondary').addClass('btn-outline-secondary');
            $('#panel_current').show();
            $('#panel_forgot').hide();
        });
        $('#mode_forgot').on('click', function(){
            $('#mode_forgot').addClass('active btn-secondary').removeClass('btn-outline-secondary');
            $('#mode_current').removeClass('active btn-primary').addClass('btn-outline-primary');
            $('#panel_current').hide();
            $('#panel_forgot').show();
        });

        // password visibility toggles
        function toggleInput(btnId, inputSelector){
            $(btnId).on('click', function(){
                var $i = $(inputSelector);
                var type = $i.attr('type') === 'password' ? 'text' : 'password';
                $i.attr('type', type);
                $(this).find('i').toggleClass('bi-eye bi-eye-slash');
            });
        }
        toggleInput('#toggleCurrent','#current_password');
        toggleInput('#toggleNew','#new_password');
        toggleInput('#toggleConfirm','#confirm_password');
        toggleInput('#toggleResetNew','#reset_new');
        toggleInput('#toggleResetConfirm','#reset_confirm');

        // realtime match checks
        function liveMatch(a,b,hintSelector){
            $(a+','+b).on('input', function(){
                var v1 = $(a).val();
                var v2 = $(b).val();
                if (!v1 && !v2) { $(hintSelector).text(''); return; }
                if (v1 === v2) {
                    $(hintSelector).text('Passwords match').css('color','#28a745');
                } else {
                    $(hintSelector).text('Passwords do not match').css('color','#dc3545');
                }
            });
        }
        liveMatch('#new_password','#confirm_password','#matchHint_current');
        liveMatch('#reset_new','#reset_confirm','#matchHint_reset');

        function showToast(text, bg, dur=3000){
            Toastify({ text:text, duration:dur, gravity:"top", position:"center", close:false, style:{ background: bg, color:'#fff' } }).showToast();
        }

        // DIRECT CHANGE (current password)
        $('#btnChangeDirect').on('click', function(){
            var $btn = $(this);
            var data = {
                teacher_id: $('#teacher_id').val(),
                current_password: $('#current_password').val(),
                new_password: $('#new_password').val(),
                confirm_password: $('#confirm_password').val()
            };
            if (!data.current_password || !data.new_password || !data.confirm_password) {
                showToast('Fill all fields', '#dc3545');
                return;
            }
            if (data.new_password !== data.confirm_password) { showToast('Passwords do not match', '#dc3545'); return; }
            showToast('Processing...', '#0d6efd', 2000);
            var orig = $btn.text();
            $btn.prop('disabled', true).text('Processing...');
            $.ajax({
                url: 'direct_change_password.php',
                type: 'POST',
                data: data,
                dataType: 'json',
                success: function(res){
                    $btn.prop('disabled', false).text(orig);
                    if (res.status === true) {
                        showToast(res.message || 'Password changed', '#28a745', 1500);
                        setTimeout(function(){ logoutModal.show(); }, 800);
                    } else {
                        showToast(res.message || 'Something went wrong', '#dc3545', 4000);
                    }
                },
                error: function(){ $btn.prop('disabled', false).text(orig); showToast('Server error', '#dc3545'); }
            });
        });

        // FORGOT: Send OTP
        $('#btnSendOTP').on('click', function(){
            var $btn = $(this);
            var email = $('#fp_email').val().trim();
            if (!email) { showToast('Enter your registered email', '#dc3545'); return; }
            showToast('Sending OTP...', '#0d6efd', 2000);
            var orig = $btn.text();
            $btn.prop('disabled', true).text('Sending...');

            $.ajax({
                url: 'fp_send_otp.php',
                type: 'POST',
                data: { email: email },
                dataType: 'json',
                success: function(res){
                    $btn.prop('disabled', false).text(orig);
                    if (res.status === true) {
                        showToast('OTP sent (may take a few moments)', '#28a745', 2000);
                        otpModal.show();
                        setTimeout(function(){ $('#otp_1').focus(); }, 350);
                    } else {
                        showToast(res.message || 'Cannot send OTP', '#dc3545', 4000);
                    }
                },
                error: function(){ $btn.prop('disabled', false).text(orig); showToast('Server error', '#dc3545'); }
            });
        });

        // Resend OTP (same endpoint)
        $('#btnResendOtp').on('click', function(){$('#btnSendOTP').trigger('click');});

        // OTP inputs: auto-advance
        $('.otp-input').on('input', function(){
            var $this = $(this);
            var val = $this.val();
            if (val.length > 1) { $this.val(val.slice(-1)); val = $this.val(); }
            if (val !== '') {$this.nextAll('.otp-input').first().focus();}
        });
        $('.otp-input').on('keydown', function(e){if (e.key === 'Backspace' && $(this).val() === '') {$(this).prevAll('.otp-input').first().focus();}});

        // Verify OTP
        $('#btnVerifyOtp').on('click', function(){
            var $btn = $(this);
            var otp = $('#otp_1').val()+$('#otp_2').val()+$('#otp_3').val()+$('#otp_4').val();
            if (otp.length !== 4) { showToast('Enter 4-digit OTP', '#dc3545'); return; }
            showToast('Verifying...', '#0d6efd', 2000);
            var orig = $btn.text(); $btn.prop('disabled', true).text('Verifying...');
            $.ajax({
                url: 'fp_verify_otp.php',
                type: 'POST',
                data: { otp: otp },
                dataType: 'json',
                success: function(res){
                    $btn.prop('disabled', false).text(orig);
                    if (res.status === true) {
                        showToast('OTP verified', '#28a745', 1500);
                        otpModal.hide();
                        $('.otp-input').val('');
                        setTimeout(function(){ newPassModal.show(); }, 300);
                    } else {
                        showToast(res.message || 'Invalid OTP', '#dc3545', 4000);
                    }
                },
                error: function(){ $btn.prop('disabled', false).text(orig); showToast('Server error', '#dc3545'); }
            });
        });

        // Reset password after OTP verified
        $('#btnResetPassword').on('click', function(){
            var $btn = $(this);
            var newp = $('#reset_new').val(), conf = $('#reset_confirm').val();
            if (!newp || !conf) { showToast('Fill both fields', '#dc3545'); return; }
            if (newp !== conf) { showToast('Passwords do not match', '#dc3545'); return; }

            showToast('Processing...', '#0d6efd', 2000);
            var orig = $btn.text(); $btn.prop('disabled', true).text('Processing...');
            $.ajax({
                url: 'fp_reset_password.php',
                type: 'POST',
                data: { new_password: newp, confirm_password: conf },
                dataType: 'json',
                success: function(res){
                    $btn.prop('disabled', false).text(orig);
                    if (res.status === true) {
                        newPassModal.hide();
                        showToast('Password updated. Please log in again.', '#28a745', 2000);
                        setTimeout(function(){ logoutModal.show(); }, 700);
                    } else {
                        showToast(res.message || 'Could not reset password', '#dc3545', 4000);
                    }
                },
                error: function(){ $btn.prop('disabled', false).text(orig); showToast('Server error', '#dc3545'); }
            });
        });

    }); 
</script>
<?php include "footerlink.php"; ?>