<?php
session_start();
if(empty($_SESSION['id'])){ 
	echo '<script>window.location.href="signin.php"</script>'; 
}
include "config.php";
include 'headerlink.php';

$classId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if (!$classId) {
    echo '<script>window.location.href="dashboard.php"</script>';
    exit;
} ?>

    <div id="main-wrapper" class="wallet-open active">
	
        <!--Nav header-->
        <div class="nav-header">
            <a href="dashboard.php" class="brand-logo">
				<!-- <svg class="logo-abbr" width="40" height="40" viewBox="0 0 48 54" fill="none" xmlns="http://www.w3.org/2000/svg">
					<rect y="3" width="48" height="48" rx="16" fill="#FB7D5B"></rect>
					<path d="M28.964 35.536H19.532L18.02 40H11.576L20.72 14.728H27.848L36.992 40H30.476L28.964 35.536ZM27.38 30.784L24.248 21.532L21.152 30.784H27.38Z" fill="white"></path>
				</svg> -->
				<div class="brand-title">
					<!-- <svg width="140" height="30" viewBox="0 0 167 30" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M17.964 24.536H8.532L7.02 29H0.576L9.72 3.728H16.848L25.992 29H19.476L17.964 24.536ZM16.38 19.784L13.248 10.532L10.152 19.784H16.38ZM41.051 29L34.931 20.576V29H28.775V2.36H34.931V17.084L41.015 8.912H48.611L40.259 18.992L48.683 29H41.051ZM49.8049 18.92C49.8049 16.856 50.1889 15.044 50.9569 13.484C51.7489 11.924 52.8169 10.724 54.1609 9.884C55.5049 9.044 57.0049 8.624 58.6609 8.624C60.0769 8.624 61.3129 8.912 62.3689 9.488C63.4489 10.064 64.2769 10.82 64.8529 11.756V8.912H71.0089V29H64.8529V26.156C64.2529 27.092 63.4129 27.848 62.3329 28.424C61.2769 29 60.0409 29.288 58.6249 29.288C56.9929 29.288 55.5049 28.868 54.1609 28.028C52.8169 27.164 51.7489 25.952 50.9569 24.392C50.1889 22.808 49.8049 20.984 49.8049 18.92ZM64.8529 18.956C64.8529 17.42 64.4209 16.208 63.5569 15.32C62.7169 14.432 61.6849 13.988 60.4609 13.988C59.2369 13.988 58.1929 14.432 57.3289 15.32C56.4889 16.184 56.0689 17.384 56.0689 18.92C56.0689 20.456 56.4889 21.68 57.3289 22.592C58.1929 23.48 59.2369 23.924 60.4609 23.924C61.6849 23.924 62.7169 23.48 63.5569 22.592C64.4209 21.704 64.8529 20.492 64.8529 18.956ZM74.2385 18.92C74.2385 16.856 74.6225 15.044 75.3905 13.484C76.1825 11.924 77.2505 10.724 78.5945 9.884C79.9385 9.044 81.4385 8.624 83.0945 8.624C84.4145 8.624 85.6145 8.9 86.6945 9.452C87.7985 10.004 88.6625 10.748 89.2865 11.684V2.36H95.4425V29H89.2865V26.12C88.7105 27.08 87.8825 27.848 86.8025 28.424C85.7465 29 84.5105 29.288 83.0945 29.288C81.4385 29.288 79.9385 28.868 78.5945 28.028C77.2505 27.164 76.1825 25.952 75.3905 24.392C74.6225 22.808 74.2385 20.984 74.2385 18.92ZM89.2865 18.956C89.2865 17.42 88.8545 16.208 87.9905 15.32C87.1505 14.432 86.1185 13.988 84.8945 13.988C83.6705 13.988 82.6265 14.432 81.7625 15.32C80.9225 16.184 80.5025 17.384 80.5025 18.92C80.5025 20.456 80.9225 21.68 81.7625 22.592C82.6265 23.48 83.6705 23.924 84.8945 23.924C86.1185 23.924 87.1505 23.48 87.9905 22.592C88.8545 21.704 89.2865 20.492 89.2865 18.956ZM118.832 18.632C118.832 19.208 118.796 19.808 118.724 20.432H104.792C104.888 21.68 105.284 22.64 105.98 23.312C106.7 23.96 107.576 24.284 108.608 24.284C110.144 24.284 111.212 23.636 111.812 22.34H118.364C118.028 23.66 117.416 24.848 116.528 25.904C115.664 26.96 114.572 27.788 113.252 28.388C111.932 28.988 110.456 29.288 108.824 29.288C106.856 29.288 105.104 28.868 103.568 28.028C102.032 27.188 100.832 25.988 99.9681 24.428C99.1041 22.868 98.6721 21.044 98.6721 18.956C98.6721 16.868 99.0921 15.044 99.9321 13.484C100.796 11.924 101.996 10.724 103.532 9.884C105.068 9.044 106.832 8.624 108.824 8.624C110.768 8.624 112.496 9.032 114.008 9.848C115.52 10.664 116.696 11.828 117.536 13.34C118.4 14.852 118.832 16.616 118.832 18.632ZM112.532 17.012C112.532 15.956 112.172 15.116 111.452 14.492C110.732 13.868 109.832 13.556 108.752 13.556C107.72 13.556 106.844 13.856 106.124 14.456C105.428 15.056 104.996 15.908 104.828 17.012H112.532ZM147.712 8.696C150.208 8.696 152.188 9.452 153.652 10.964C155.14 12.476 155.884 14.576 155.884 17.264V29H149.764V18.092C149.764 16.796 149.416 15.8 148.72 15.104C148.048 14.384 147.112 14.024 145.912 14.024C144.712 14.024 143.764 14.384 143.068 15.104C142.396 15.8 142.06 16.796 142.06 18.092V29H135.94V18.092C135.94 16.796 135.592 15.8 134.896 15.104C134.224 14.384 133.288 14.024 132.088 14.024C130.888 14.024 129.94 14.384 129.244 15.104C128.572 15.8 128.236 16.796 128.236 18.092V29H122.08V8.912H128.236V11.432C128.86 10.592 129.676 9.932 130.684 9.452C131.692 8.948 132.832 8.696 134.104 8.696C135.616 8.696 136.96 9.02 138.136 9.668C139.336 10.316 140.272 11.24 140.944 12.44C141.64 11.336 142.588 10.436 143.788 9.74C144.988 9.044 146.296 8.696 147.712 8.696ZM163.285 6.824C162.205 6.824 161.317 6.512 160.621 5.888C159.949 5.24 159.613 4.448 159.613 3.512C159.613 2.552 159.949 1.76 160.621 1.136C161.317 0.487998 162.205 0.163998 163.285 0.163998C164.341 0.163998 165.205 0.487998 165.877 1.136C166.573 1.76 166.921 2.552 166.921 3.512C166.921 4.448 166.573 5.24 165.877 5.888C165.205 6.512 164.341 6.824 163.285 6.824ZM166.345 8.912V29H160.189V8.912H166.345Z" fill="white"></path>
					</svg> -->
					<h4 class="fw-bold text-white">Kolkata Dealer</h4>
				</div> 
            </a>
            <div class="nav-control">
                <div class="hamburger">
                    <span class="line"></span><span class="line"></span><span class="line"></span>
					<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
						<rect x="22" y="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="11" y="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="11" y="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect y="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="22" y="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect y="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
					</svg>		
                </div>
            </div>
        </div>
        <!--/Nav header-->
		
		<!-- header -->
		<div class="header">
			<div class="header-content">
				<nav class="navbar navbar-expand">
					<div class="collapse navbar-collapse justify-content-between">
						<div class="header-left">
							<div class="dashboard_bar">Class View</div>
						</div>
						<?php include "header.php"; ?>
					</div>
				</nav>
			</div>
		</div>
		<!-- /header -->
		 
		<?php 
		include "sidebar.php";
		$stmt = $pdo->prepare("SELECT * FROM departments WHERE id = :id LIMIT 1");
        $stmt->execute([':id' => $classId]);
        $class = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$class) {
            echo '<script>window.location.href="dashboard.php"</script>';
            exit;
        }

        // departments where departments.class_id = :id
        $deps1 = [];
        try {
            $st1 = $pdo->prepare("SELECT * FROM classes WHERE department_id = :id ORDER BY name");
            $st1->execute([':id' => $classId]);
            $deps1 = $st1->fetchAll(PDO::FETCH_ASSOC);
        } catch (\Throwable $e) {
            $deps1 = [];
        }

        // departments joined via classes.department_id = departments.id 
        $deps2 = [];
        try {
            $st2 = $pdo->prepare("SELECT d.* FROM departments d JOIN classes c ON c.department_id = d.id WHERE c.id = :id ORDER BY d.name");
            $st2->execute([':id' => $classId]);
            $deps2 = $st2->fetchAll(PDO::FETCH_ASSOC);
        } catch (\Throwable $e) {
            $deps2 = [];
        }

        $departments = [];
        foreach (array_merge($deps1, $deps2) as $d) {
            $departments[$d['id']] = $d;
        }
        $departments = array_values($departments);

        $sectionsByDept = [];
        foreach ($departments as $d) {
            $did = $d['id'];
            $sectionsByDept[$did] = [];
            try {
                $s1 = $pdo->prepare("SELECT * FROM sections WHERE class_id = :did ORDER BY name");
                $s1->execute([':did' => $did]);
                $rows = $s1->fetchAll(PDO::FETCH_ASSOC);
                if (!empty($rows)) {
                    $sectionsByDept[$did] = $rows;
                    continue;
                }
            } catch (\Throwable $e) {
                // ignore
            }

            // If nothing, attempt sections where class_id = :classId and section has dept_id equal to this dept id 
            try {
                $s2 = $pdo->prepare("SELECT * FROM sections WHERE class_id = :cid ORDER BY name");
                $s2->execute([':cid' => $did]);
                $rows2 = $s2->fetchAll(PDO::FETCH_ASSOC);
                if (!empty($rows2)) {
                    $sectionsByDept[$did] = $rows2;
                    continue;
                }
            } catch (\Throwable $e) {
                // ignore
            }
        } ?>
		

        <!--Content body-->
		<div class="content-body">
            <div class="container-fluid">
                <div class="row mb-3">
                    <div class="col-8">
                        <h3 class="mb-0">Class: <?= htmlspecialchars($class['name']) ?></h3>
                        <?php if (!empty($class['capacity'])): ?>
                            <p class="text-muted">Capacity: <?= htmlspecialchars($class['capacity']) ?> students</p>
                        <?php endif; ?>
                    </div>
                    <div class="col-4 text-end">
                        <button id="addDeptBtn" class="btn btn-primary mb-3 add-item-btn" data-type="Department" data-dept-id="<?= $class['id'] ?>">
                            <i class="bi bi-plus-circle"></i> Add Department
                        </button>
                        <a href="dashboard.php" class="btn btn-outline-secondary mb-3">Back to Classes</a>
                    </div>
                </div>

                <div class="row g-3">
                    <?php if (empty($departments)): ?>
                        <div class="col-12">
                            <div class="card shadow-sm rounded-4">
                                <div class="card-body text-center text-muted">
                                    No departments found for this class yet. Use "Add Department" to create one.
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <?php foreach ($departments as $dept): ?>
                            <div class="col-md-6">
                                <div class="card h-100 shadow-sm rounded-4">
                                    <div class="card-header d-flex justify-content-between align-items-center">
                                        <div>
                                            <h5 class="mb-0 text-secondary"><?= htmlspecialchars($dept['name']) ?></h5>
                                            <?php if (!empty($dept['capacity'])): ?>
                                                <p class="text-dark fw-semibold mb-0">Capacity: <?= htmlspecialchars($dept['capacity']) ?> Students</p>
                                            <?php endif; ?>
                                        </div>
                                        <div class="d-flex align-items-center">
                                            <button class="btn btn-sm btn-secondary add-item-btn me-2" data-type="Section" data-class-id="<?= $dept['id'] ?>">
                                                <i class="bi bi-folder-plus"></i>
                                            </button>
                                            <!-- <button class="btn btn-sm btn-danger light delete-dept-btn" data-id="<?= $dept['id'] ?>">
                                                <i class="bi bi-trash-fill"></i>
                                            </button> -->
                                        </div>
                                    </div>

                                    <ul class="list-group list-group-flush">
                                        <?php
                                        $secList = isset($sectionsByDept[$dept['id']]) ? $sectionsByDept[$dept['id']] : [];
                                        if (empty($secList)): ?>
                                        <li class="list-group-item text-center text-muted small">No sections</li>
                                        <?php else: ?>
                                            <?php foreach ($secList as $sec): ?>
                                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <p class="mb-0 text-dark fw-semibold">
                                                            <?= htmlspecialchars($sec['name']) ?>
                                                            <?php if (!empty($sec['capacity'])): ?>
                                                                <span class="text-secondary fw-semibold"> (Capacity: <?= htmlspecialchars($sec['capacity']) ?>)</span>
                                                            <?php else: ?>
                                                                <span class="text-secondary fw-semibold"> (Capacity not defined.)</span>
                                                            <?php endif; ?>
                                                        </p>
                                                    </div>
                                                    <button class="btn btn-sm btn-danger light del-item-btn" data-id="<?= $sec['id'] ?>" data-type="Section">
                                                        <i class="bi bi-x-circle"></i>
                                                    </button>
                                                </li>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </ul>

                                    <div class="card-footer border-0 text-end">
                                        <button class="btn btn-sm btn-danger light del-item-btn" data-id="<?= $dept['id'] ?>" data-type="Class">
                                            <i class="bi bi-trash-fill me-1"></i>Delete
                                        </button>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Modals: reuse same modal HTML as dashboard -->
            <div class="modal fade" id="itemModal" tabindex="-1">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content rounded-4 shadow-sm">
                        <div class="modal-header">
                            <h5 class="modal-title"><span id="modalTitle"></span></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group mb-2">
                                        <label for="itemName">Enter name</label>
                                        <input id="itemName" type="text" class="form-control" placeholder="Enter name…" required>
                                    </div>
                                </div>
                                <div id="capacityField" class="col-12" style="display: none;">
                                    <div class="form-group">
                                        <label for="itemCapacity">Capacity</label>
                                        <input id="itemCapacity" name="capacity" type="number" step="1" class="form-control" placeholder="Capacity">
                                    </div>
                                </div>
                            </div>
                            <input id="parentId" type="hidden">
                            <input id="itemType" type="hidden">
                        </div>
                        <div class="modal-footer">
                            <button id="saveBtn" class="btn btn-primary">Save</button>
                            <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Delete Confirmation -->
            <div class="modal fade" id="confirmDeleteModal" tabindex="-1">
                <div class="modal-dialog modal-sm modal-dialog-centered">
                    <div class="modal-content rounded-4 shadow-sm">
                        <div class="modal-header">
                            <h5 class="modal-title">Confirm Delete</h5>
                            <button class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">Are you sure?</div>
                        <div class="modal-footer">
                            <button id="confirmDeleteBtn" class="btn btn-danger">Yes, delete</button>
                            <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>

		<?php include "footer.php" ?>

	</div>
    
<!-- All necessary scripts are here -->
<script>
    $(function(){
        const itemModal = new bootstrap.Modal('#itemModal');
        const confirmModal = new bootstrap.Modal('#confirmDeleteModal');
        let deleteInfo = {};

        function toast(msg, bg='#28a745'){
            Toastify({ text: msg, backgroundColor: bg, gravity:'top', position:'center' }).showToast();
        }

        // Add Department button on class view: opens modal for Department
        $('#addDeptBtn').click(()=>{
            $('#modalTitle').text('Add Department');
            $('#itemType').val('Department');
            $('#parentId').val('');
            $('#itemName').val('');
            $('#itemCapacity').val('');

            $('#capacityField').show();
            itemModal.show();
        });

        // Add Class/Section (reused behavior)
        $('.add-item-btn').click(function(){
            const type = $(this).data('type');
            $('#modalTitle').text('Add '+type);
            $('#itemType').val(type);
            $('#parentId').val(type=='Department'? $(this).data('dept-id'): $(this).data('class-id'));
            $('#itemName').val('');
            $('#itemCapacity').val('');

            $('#capacityField').show();
            itemModal.show();
        });

        // Save any item (uses your existing endpoints)
        $('#saveBtn').click(()=>{
            const name = $('#itemName').val().trim();
            const type = $('#itemType').val();
            const pid  = $('#parentId').val();
            const capacity = $('#itemCapacity').val();
            if(!name) return toast('Enter name!', '#e74c3c');
            const urlMap = { Class:'add_department.php', Department:'add_class.php', Section:'add_section.php' };
            $.post(urlMap[type], { name, parent_id:pid, capacity, type }, res=>{
                if(res.status=='success'){
                    toast(type+' added!'); itemModal.hide(); setTimeout(()=>location.reload(),500);
                } else toast(res.message,'#e74c3c');
            }, 'json').fail(()=>{
                toast('Server error','#e74c3c');
            });
        });

        // Delete (dept/class/section)
        $('.delete-dept-btn, .del-item-btn').click(function(){
            deleteInfo = { id: $(this).data('id'), type: $(this).data('type')|| 'Department', el: $(this).closest('.card, .card-body') };
            confirmModal.show();
        });

        // Confirm delete
        $('#confirmDeleteBtn').click(()=>{
            const {id,type,el} = deleteInfo;
            const urlMap = { Department:'delete_department.php', Class:'delete_class.php', Section:'delete_section.php' };
            $.post(urlMap[type], { id, type }, res=>{
                if(res.status=='success'){
                    toast(type+' deleted!'); confirmModal.hide(); setTimeout(()=>location.reload(),500);
                } else toast(res.message,'#e74c3c');
            }, 'json').fail(()=>{
                toast('Server error','#e74c3c');
            });
        });
    });
</script>
<?php include "footerlink.php"; ?>