<?php
session_start();
if(empty($_SESSION['id'])){ echo '<script>window.location.href="signin.php"</script>'; }
include "config.php";
include 'headerlink.php'; ?>

<style>
	.holiday-card { border-radius: .8rem; box-shadow: 0 6px 20px rgba(22,28,45,0.06); }
	.holiday-header { border-bottom: 1px solid rgba(0,0,0,0.05); padding: 1rem 1.25rem; }
	.holiday-body { padding: 1rem 1.25rem; }
	.holiday-item { transition: transform .12s ease, box-shadow .12s ease; }
	.holiday-item:hover { transform: translateY(-3px); box-shadow: 0 6px 18px rgba(22,28,45,0.06); }
	.holiday-meta { font-size: .85rem; color: #6c757d; }
	.holiday-link { font-size: .95rem; color: #0d6efd; text-decoration: none; }
	.holiday-link:hover { text-decoration: underline; }
	.badge-today { background: linear-gradient(90deg,#ff8a65,#ff7043); color: #fff; }
	.badge-upcoming { background: linear-gradient(90deg,#7bc6ff,#4aa3ff); color: #fff; }
	.no-events { color: #6c757d; font-style: italic; }
</style>

    <div id="main-wrapper" class="wallet-open active">
	
        <!--Nav header-->
        <div class="nav-header">
            <a href="dashboard.php" class="brand-logo">
				<!-- <svg class="logo-abbr" width="40" height="40" viewBox="0 0 48 54" fill="none" xmlns="http://www.w3.org/2000/svg">
					<rect y="3" width="48" height="48" rx="16" fill="#FB7D5B"></rect>
					<path d="M28.964 35.536H19.532L18.02 40H11.576L20.72 14.728H27.848L36.992 40H30.476L28.964 35.536ZM27.38 30.784L24.248 21.532L21.152 30.784H27.38Z" fill="white"></path>
				</svg> -->
				<div class="brand-title">
					<!-- <svg width="140" height="30" viewBox="0 0 167 30" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M17.964 24.536H8.532L7.02 29H0.576L9.72 3.728H16.848L25.992 29H19.476L17.964 24.536ZM16.38 19.784L13.248 10.532L10.152 19.784H16.38ZM41.051 29L34.931 20.576V29H28.775V2.36H34.931V17.084L41.015 8.912H48.611L40.259 18.992L48.683 29H41.051ZM49.8049 18.92C49.8049 16.856 50.1889 15.044 50.9569 13.484C51.7489 11.924 52.8169 10.724 54.1609 9.884C55.5049 9.044 57.0049 8.624 58.6609 8.624C60.0769 8.624 61.3129 8.912 62.3689 9.488C63.4489 10.064 64.2769 10.82 64.8529 11.756V8.912H71.0089V29H64.8529V26.156C64.2529 27.092 63.4129 27.848 62.3329 28.424C61.2769 29 60.0409 29.288 58.6249 29.288C56.9929 29.288 55.5049 28.868 54.1609 28.028C52.8169 27.164 51.7489 25.952 50.9569 24.392C50.1889 22.808 49.8049 20.984 49.8049 18.92ZM64.8529 18.956C64.8529 17.42 64.4209 16.208 63.5569 15.32C62.7169 14.432 61.6849 13.988 60.4609 13.988C59.2369 13.988 58.1929 14.432 57.3289 15.32C56.4889 16.184 56.0689 17.384 56.0689 18.92C56.0689 20.456 56.4889 21.68 57.3289 22.592C58.1929 23.48 59.2369 23.924 60.4609 23.924C61.6849 23.924 62.7169 23.48 63.5569 22.592C64.4209 21.704 64.8529 20.492 64.8529 18.956ZM74.2385 18.92C74.2385 16.856 74.6225 15.044 75.3905 13.484C76.1825 11.924 77.2505 10.724 78.5945 9.884C79.9385 9.044 81.4385 8.624 83.0945 8.624C84.4145 8.624 85.6145 8.9 86.6945 9.452C87.7985 10.004 88.6625 10.748 89.2865 11.684V2.36H95.4425V29H89.2865V26.12C88.7105 27.08 87.8825 27.848 86.8025 28.424C85.7465 29 84.5105 29.288 83.0945 29.288C81.4385 29.288 79.9385 28.868 78.5945 28.028C77.2505 27.164 76.1825 25.952 75.3905 24.392C74.6225 22.808 74.2385 20.984 74.2385 18.92ZM89.2865 18.956C89.2865 17.42 88.8545 16.208 87.9905 15.32C87.1505 14.432 86.1185 13.988 84.8945 13.988C83.6705 13.988 82.6265 14.432 81.7625 15.32C80.9225 16.184 80.5025 17.384 80.5025 18.92C80.5025 20.456 80.9225 21.68 81.7625 22.592C82.6265 23.48 83.6705 23.924 84.8945 23.924C86.1185 23.924 87.1505 23.48 87.9905 22.592C88.8545 21.704 89.2865 20.492 89.2865 18.956ZM118.832 18.632C118.832 19.208 118.796 19.808 118.724 20.432H104.792C104.888 21.68 105.284 22.64 105.98 23.312C106.7 23.96 107.576 24.284 108.608 24.284C110.144 24.284 111.212 23.636 111.812 22.34H118.364C118.028 23.66 117.416 24.848 116.528 25.904C115.664 26.96 114.572 27.788 113.252 28.388C111.932 28.988 110.456 29.288 108.824 29.288C106.856 29.288 105.104 28.868 103.568 28.028C102.032 27.188 100.832 25.988 99.9681 24.428C99.1041 22.868 98.6721 21.044 98.6721 18.956C98.6721 16.868 99.0921 15.044 99.9321 13.484C100.796 11.924 101.996 10.724 103.532 9.884C105.068 9.044 106.832 8.624 108.824 8.624C110.768 8.624 112.496 9.032 114.008 9.848C115.52 10.664 116.696 11.828 117.536 13.34C118.4 14.852 118.832 16.616 118.832 18.632ZM112.532 17.012C112.532 15.956 112.172 15.116 111.452 14.492C110.732 13.868 109.832 13.556 108.752 13.556C107.72 13.556 106.844 13.856 106.124 14.456C105.428 15.056 104.996 15.908 104.828 17.012H112.532ZM147.712 8.696C150.208 8.696 152.188 9.452 153.652 10.964C155.14 12.476 155.884 14.576 155.884 17.264V29H149.764V18.092C149.764 16.796 149.416 15.8 148.72 15.104C148.048 14.384 147.112 14.024 145.912 14.024C144.712 14.024 143.764 14.384 143.068 15.104C142.396 15.8 142.06 16.796 142.06 18.092V29H135.94V18.092C135.94 16.796 135.592 15.8 134.896 15.104C134.224 14.384 133.288 14.024 132.088 14.024C130.888 14.024 129.94 14.384 129.244 15.104C128.572 15.8 128.236 16.796 128.236 18.092V29H122.08V8.912H128.236V11.432C128.86 10.592 129.676 9.932 130.684 9.452C131.692 8.948 132.832 8.696 134.104 8.696C135.616 8.696 136.96 9.02 138.136 9.668C139.336 10.316 140.272 11.24 140.944 12.44C141.64 11.336 142.588 10.436 143.788 9.74C144.988 9.044 146.296 8.696 147.712 8.696ZM163.285 6.824C162.205 6.824 161.317 6.512 160.621 5.888C159.949 5.24 159.613 4.448 159.613 3.512C159.613 2.552 159.949 1.76 160.621 1.136C161.317 0.487998 162.205 0.163998 163.285 0.163998C164.341 0.163998 165.205 0.487998 165.877 1.136C166.573 1.76 166.921 2.552 166.921 3.512C166.921 4.448 166.573 5.24 165.877 5.888C165.205 6.512 164.341 6.824 163.285 6.824ZM166.345 8.912V29H160.189V8.912H166.345Z" fill="white"></path>
					</svg> -->
					<h4 class="fw-bold text-white">Kolkata Dealer</h4>
				</div> 
            </a>
            <div class="nav-control">
                <div class="hamburger">
                    <span class="line"></span><span class="line"></span><span class="line"></span>
					<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
						<rect x="22" y="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="11" y="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="11" y="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect y="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="22" y="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect y="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
					</svg>		
                </div>
            </div>
        </div>
        <!--/Nav header-->
		
		<!-- header -->
		<div class="header">
			<div class="header-content">
				<nav class="navbar navbar-expand">
					<div class="collapse navbar-collapse justify-content-between">
						<div class="header-left">
							<div class="dashboard_bar">Dashboard</div>
						</div>
						<?php include "header.php"; ?>
					</div>
				</nav>
			</div>
		</div>
		<!-- /header -->
		<?php 
		include "sidebar.php";
		$sql = "SELECT id, name FROM departments WHERE school_id = $adminSchoolId ORDER BY name";
    	$classes = $pdo->query($sql)->fetchAll();
		
		$today = date('Y-m-d');

		$stmtToday = $pdo->prepare("SELECT id, name, start_date, end_date FROM holidays WHERE school_id = :sid AND start_date <= :today_start AND end_date >= :today_end ORDER BY start_date ASC");
		$stmtToday->execute([
			':sid' => $adminSchoolId,
			':today_start' => $today,
			':today_end'   => $today
		]);
		$todayEvents = $stmtToday->fetchAll(PDO::FETCH_ASSOC);

		$stmtUpcoming = $pdo->prepare("SELECT id, name, start_date, end_date FROM holidays WHERE school_id = :sid AND start_date > :today_after ORDER BY start_date ASC LIMIT 5");
		$stmtUpcoming->execute([
			':sid' => $adminSchoolId,
			':today_after' => $today
		]);
		$upcomingEvents = $stmtUpcoming->fetchAll(PDO::FETCH_ASSOC);

		function fmtHolidayRange(string $start, string $end) : string {
			$d1 = new DateTime($start);
			$d2 = new DateTime($end);

			// same day -> e.g. "19 Aug 2025"
			if ($d1->format('Y-m-d') === $d2->format('Y-m-d')) {return $d1->format('j M Y');}
			// same month and year -> "1–5 Jul 2025"
			if ($d1->format('Y') === $d2->format('Y') && $d1->format('n') === $d2->format('n')) {return $d1->format('j') . '–' . $d2->format('j M Y');}
			// same year -> "28 Jun – 5 Jul 2025"
			if ($d1->format('Y') === $d2->format('Y')) {return $d1->format('j M') . ' – ' . $d2->format('j M Y');}
			// different years -> "29 Dec 2025 – 2 Jan 2026"
			return $d1->format('j M Y') . ' – ' . $d2->format('j M Y');
		} ?>
		

        <!--Content body-->
		<div class="content-body">
			<div class="container-fluid">
				<h4 class="fw-bold mb-3"><?= $adminSchool ?> Login</h4>
				<!-- holidays -->
				<div class="row">
					<div class="col-xl-12">
						<div class="card holiday-card mb-4">
							<div class="d-flex align-items-center justify-content-between holiday-header">
								<div class="d-flex align-items-center gap-3">
									<div class="rounded-3 p-2" style="background: linear-gradient(135deg,#f5f7ff,#eef6ff);">
										<svg width="22" height="22" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M7 10h5v5H7z" fill="#4aa3ff"/>
											<path d="M19 4h-1V2h-2v2H8V2H6v2H5a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM5 20V9h14v11H5z" fill="#2b6fda"/>
										</svg>
									</div>
									<div>
										<h5 class="mb-0 fw-bold">Holidays</h5>
										<div class="small text-muted">Today & upcoming school holidays</div>
									</div>
								</div>
								<div class="text-end"><a href="holiday_list.php" class="holiday-link">See all holidays →</a></div>
							</div>
							<div class="holiday-body">
								<!-- Today's events -->
								<div class="mb-3">
									<div class="d-flex align-items-center justify-content-between mb-2">
										<div class="fw-semibold">Today</div>
										<div class="holiday-meta"><?= htmlspecialchars((new DateTime($today))->format('j M Y')) ?></div>
									</div>
									<?php if (!empty($todayEvents)): ?>
									<div class="row g-2">
									<?php foreach ($todayEvents as $ev): ?>
										<div class="col-md-6">
										<div class="card border-0 holiday-item">
											<div class="card-body p-3 d-flex justify-content-between align-items-start">
												<div>
													<div class="fw-bold"><?= htmlspecialchars($ev['name']) ?></div>
													<div class="holiday-meta mt-1"><?= htmlspecialchars(fmtHolidayRange($ev['start_date'], $ev['end_date'])) ?></div>
												</div>
												<div class="text-end">
													<span class="badge badge-today rounded-pill py-2 px-3">Today</span>
												</div>
											</div>
										</div>
										</div>
									<?php endforeach; ?>
									</div>
									<?php else: ?>
									<div class="no-events">No holidays today.</div>
									<?php endif; ?>
								</div>
								<hr>
								<!-- Upcoming events -->
								<div>
									<div class="d-flex align-items-center justify-content-between mb-2">
										<div class="fw-semibold">Upcoming</div>
										<div class="holiday-meta">Next <?= count($upcomingEvents) ?> events</div>
									</div>
									<?php if (!empty($upcomingEvents)): ?>
									<div class="list-group list-group-flush">
										<?php foreach ($upcomingEvents as $ev): ?>
										<div class="list-group-item border-0 px-0 py-2 d-flex align-items-center justify-content-between holiday-item">
											<div>
												<div class="fw-semibold"><?= htmlspecialchars($ev['name']) ?></div>
												<div class="holiday-meta"><?= htmlspecialchars(fmtHolidayRange($ev['start_date'], $ev['end_date'])) ?></div>
											</div>
											<div class="text-end">
												<span class="badge badge-upcoming rounded-pill py-2 px-3"><?= (new DateTime($ev['start_date']))->format('j M') ?></span>
											</div>
										</div>
										<?php endforeach; ?>
									</div>
									<?php else: ?>
									<div class="no-events">No upcoming holidays scheduled.</div>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
				<!-- All classes cards -->
				<div class="row g-4">
					<div class="col-12 text-center">
						<button id="addDeptBtn" class="btn btn-primary mb-3"><i class="bi bi-plus-circle"></i> Add Class</button>
					</div>
					<?php if(empty($classes)): ?>
					<div class="col-12">
						<div class="card mb-4 shadow-sm rounded-4">
							<div class="card-body text-center text-muted">
								No classes added yet.
							</div>
						</div>
					</div>
					<?php else: ?>
					<?php foreach($classes as $cls): ?>
					<div class="col-md-4">
						<div class="card h-100 shadow-sm rounded-4">
							<div class="card-header d-flex justify-content-between align-items-center">
								<div class="d-flex flex-column justify-content-center align-items-start">
									<h5 class="mb-0 text-secondary"><?= htmlspecialchars($cls['name']) ?></h5>
								</div>
								<div class="d-flex">
									<a href="class_view.php?id=<?= $cls['id'] ?>" class="btn btn-sm btn-primary me-2">
										<i class="bi bi-eye"></i> View
									</a>
									<button class="btn btn-sm btn-danger light del-item-btn" data-id="<?= $cls['id'] ?>" data-type="Class">
										<i class="bi bi-trash-fill"></i>
									</button>
								</div>
							</div>
						</div>
					</div>
					<?php endforeach; ?>
					<?php endif; ?>
				</div>
			</div>
			<!-- Modals: Department / Class / Section -->
			<div class="modal fade" id="itemModal" tabindex="-1">
				<div class="modal-dialog modal-dialog-centered">
					<div class="modal-content rounded-4 shadow-sm">
						<div class="modal-header">
							<h5 class="modal-title"><span id="modalTitle"></span></h5>
							<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
						</div>
						<div class="modal-body">
							<div class="row">
								<div class="col-12">
									<div class="form-group mb-2">
										<label for="itemName">Enter name</label>
										<input id="itemName" type="text" class="form-control" placeholder="Enter name…" required>
									</div>
								</div>
							</div>
							<input id="parentId" type="hidden">
							<input id="itemType" type="hidden">
						</div>
						<div class="modal-footer">
							<button id="saveBtn" class="btn btn-primary">Save</button>
							<button class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
						</div>
					</div>
				</div>
			</div>
			<!-- Delete Confirmation -->
			<div class="modal fade" id="confirmDeleteModal" tabindex="-1">
				<div class="modal-dialog modal-sm modal-dialog-centered">
					<div class="modal-content rounded-4 shadow-sm">
						<div class="modal-header">
							<h5 class="modal-title">Confirm Delete</h5>
							<button class="btn-close" data-bs-dismiss="modal"></button>
						</div>
						<div class="modal-body">Are you sure?</div>
						<div class="modal-footer">
							<button id="confirmDeleteBtn" class="btn btn-danger">Yes, delete</button>
							<button class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
						</div>
					</div>
				</div>
			</div>
		</div>

		<?php include "footer.php" ?>

	</div>
    
<!-- All necessary scripts are here -->
<script>
	$(function(){
		const itemModal = new bootstrap.Modal('#itemModal');
		const confirmModal = new bootstrap.Modal('#confirmDeleteModal');
		let deleteInfo = {};
		const SCHOOL_ID = <?= (int)$adminSchoolId ?>;

		function toast(msg, bg='#28a745'){
			Toastify({ text: msg, backgroundColor: bg, gravity:'top', position:'center' }).showToast();
		}

		$('#addDeptBtn').click(()=>{
			$('#modalTitle').text('Add Class');
			$('#itemType').val('Class');
			$('#parentId').val('');
			$('#itemName').val('');
			itemModal.show();
		});

		$('.add-item-btn').click(function(){
			const type = $(this).data('type');
			$('#modalTitle').text('Add '+type);
			$('#itemType').val(type);
			$('#parentId').val(type=='Department'? $(this).data('dept-id'): $(this).data('class-id'));
			$('#itemName').val('');
			$('#itemCapacity').val('');

			$('#capacityField').show();
			itemModal.show();
		});

		// Save any item
		$('#saveBtn').click(()=>{
			const name = $('#itemName').val().trim();
			const type = $('#itemType').val();
			const pid  = $('#parentId').val();
			const capacity = $('#itemCapacity').val();
			if(!name) return toast('Enter name!', '#e74c3c');

			const urlMap = { Class:'add_department.php', Department:'add_class.php', Section:'add_section.php' };
			const url = urlMap[type];
			const data = { name, parent_id: pid, capacity, type };
			if(type === 'Class') data.school_id = SCHOOL_ID;

			$.post(url, data, res=>{
				if(res.status=='success'){
					toast(type+' added!'); itemModal.hide(); setTimeout(()=>location.reload(),500);
				} else toast(res.message || 'Server error',' #e74c3c');
			}, 'json').fail(()=>{
				toast('Server error','#e74c3c');
			});
		});

		// Delete (dept/class/section)
		$('.delete-dept-btn, .del-item-btn').click(function(){
			deleteInfo = { id: $(this).data('id'), type: $(this).data('type')|| 'Department', el: $(this).closest('.card, .card-body') };
			confirmModal.show();
		});

		// Confirm delete
		$('#confirmDeleteBtn').click(()=>{
			const {id,type,el} = deleteInfo;
			const urlMap = { Department:'delete_department.php', Class:'delete_department.php', Section:'delete_section.php' };
			const url = urlMap[type];
			const data = { id, type, school_id: SCHOOL_ID };

			$.post(url, data, res=>{
				if(res.status=='success'){
					toast(type+' deleted!'); confirmModal.hide(); setTimeout(()=>location.reload(),500);
				} else toast(res.message || 'Server error','#e74c3c');
			}, 'json').fail(()=>{
				toast('Server error','#e74c3c');
			});
		});
	});
</script>
<?php include "footerlink.php"; ?>