<?php
session_start();
require 'config.php';
header('Content-Type: application/json');
$act = $_REQUEST['action'] ?? '';
$adminSchool = $_SESSION['school'] ?? '';

// getClasses
if($act==='getClasses'){
  $stm=$pdo->prepare("SELECT id,name FROM classes WHERE department_id=?");
  $stm->execute([$_REQUEST['department_id']]);
  echo json_encode($stm->fetchAll());
  exit;
}

// getSections
if($act==='getSections'){
  $stm=$pdo->prepare("SELECT id,name FROM sections WHERE class_id=?");
  $stm->execute([$_REQUEST['class_id']]);
  echo json_encode($stm->fetchAll());
  exit;
}

// getAllTeachers
if($act==='getAllTeachers'){
  $stm=$pdo->prepare("SELECT id,name FROM teachers WHERE school=?");
  $stm->execute([$adminSchool]);
  echo json_encode($stm->fetchAll());
  exit;
}

// buildSlots 
if($act==='buildSlots'){
  $s=new DateTime($_REQUEST['school_start']);
  $pd=(int)$_REQUEST['period_duration'];
  $tb=(int)$_REQUEST['tiffin_break_duration'];
  $bef=(int)$_REQUEST['slots_before_tiffin'];
  $aft=(int)$_REQUEST['slots_after_tiffin'];
  $wd=(int)$_REQUEST['weekdays_count'];
  $all=['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'];
  $days=array_slice($all,0,$wd);

  ob_start();
  echo '<div class="table-responsive"><table class="table table-bordered"><thead><tr><th>Day</th>';
  for($i=1; $i<=$bef; $i++){echo "<th>Slot {$i}</th>";}   
  echo "<th>Tiffin</th>";
  for($i=$bef+1; $i<=$bef+$aft; $i++){echo "<th>Slot {$i}</th>";}
  echo '</tr></thead><tbody>';
  foreach($days as $day){
    echo "<tr><td>$day</td>";
    $cur=clone $s; $ord=1;
    // before tiffin
    for($i=0;$i<$bef;$i++,$ord++){
      $start=clone $cur;
      $end  =(clone $cur)->modify("+{$pd} minutes");
      echo slotCell($day,$ord,$start,$end);
      $cur=$end;
    }
    // tiffin break
    $end=(clone $cur)->modify("+{$tb} minutes");
    echo "<td class='text-center'>Tiffin<br>{$cur->format('H:i')} - {$end->format('H:i')}</td>";
    $cur=$end;
    // after tiffin
    for($i=0;$i<$aft;$i++,$ord++){
      $start=clone $cur;
      $end  =(clone $cur)->modify("+{$pd} minutes");
      echo slotCell($day,$ord,$start,$end);
      $cur=$end;
    }
    echo '</tr>';
  }
  echo '</tbody></table></div>';
  exit;
}

// saveRoutine
if($act==='saveRoutine'){
  $pdo->beginTransaction();
  $ins=$pdo->prepare("INSERT INTO routines (department_id,class_id,section_id,school_start,period_duration, tiffin_break_duration,slots_before_tiffin,slots_after_tiffin,weekdays_count) VALUES (?,?,?,?,?,?,?,?,?)");
  $ins->execute([
    $_REQUEST['department_id']?:null,
    $_REQUEST['class_id']?:null,
    $_REQUEST['section_id']?:null,
    $_REQUEST['school_start'],
    $_REQUEST['period_duration'],
    $_REQUEST['tiffin_break_duration'],
    $_REQUEST['slots_before_tiffin'],
    $_REQUEST['slots_after_tiffin'],
    $_REQUEST['weekdays_count']
  ]);
  $rid=$pdo->lastInsertId();
  build_and_insert_slots($pdo,$rid,$_REQUEST);

  foreach($_REQUEST['slots'] as $day=>$slots){
    foreach($slots as $ord=>$info){
      if(empty($info['teacher'])) continue; 
      $s=$pdo->prepare("SELECT id FROM routine_slots WHERE routine_id=? AND weekday=? AND slot_order=?");
      $s->execute([$rid,$day,$ord]);
      $slotId=$s->fetchColumn();
      $a=$pdo->prepare("INSERT INTO routine_assignments (slot_id,subject,teacher_id) VALUES (?,?,?)");
      $a->execute([$slotId,$info['subject'],$info['teacher']]);
    }
  }
  $pdo->commit();
  echo json_encode(['success'=>true]);
  exit;
}

// Helpers
function slotCell($day,$ord,DateTime $st,DateTime $et){
  $fmt=fn($t)=>$t->format('H:i');
  $base="slots[$day][$ord]";
  return "<td>
    <div>{$fmt($st)} - {$fmt($et)}</div>
    <input type='text' name='{$base}[subject]'     placeholder='Subject'       class='form-control mb-1'>
    <input type='text' name='{$base}[teacher_name]' placeholder='Teacher' list='teachersList' data-day='$day' data-order='$ord' class='form-control mb-1'>
    <input type='hidden' name='{$base}[teacher]'  value=''>
  </td>";
}

function build_and_insert_slots(PDO $pdo,$rid,$d){
  $s=new DateTime($d['school_start']);
  $pd=(int)$d['period_duration'];
  $tb=(int)$d['tiffin_break_duration'];
  $bef=(int)$d['slots_before_tiffin'];
  $aft=(int)$d['slots_after_tiffin'];
  $wd=(int)$d['weekdays_count'];
  $all=['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'];
  $days=array_slice($all,0,$wd);
  $ins=$pdo->prepare("INSERT INTO routine_slots (routine_id,weekday,slot_order,start_time,end_time,is_tiffin_break) VALUES (?,?,?,?,?,?)");
  foreach($days as $day){
    $c=clone $s; $ord=1;
    for($i=0;$i<$bef;$i++,$ord++){
      $e=(clone $c)->modify("+{$pd} minutes");
      $ins->execute([$rid,$day,$ord,$c->format('H:i:s'),$e->format('H:i:s'),0]);
      $c=$e;
    }
    $e=(clone $c)->modify("+{$tb} minutes");
    $ins->execute([$rid,$day,$ord,$c->format('H:i:s'),$e->format('H:i:s'),1]);
    $c=$e; $ord++;
    for($i=0;$i<$aft;$i++,$ord++){
      $e=(clone $c)->modify("+{$pd} minutes");
      $ins->execute([$rid,$day,$ord,$c->format('H:i:s'),$e->format('H:i:s'),0]);
      $c=$e;
    }
  }
} ?>