<?php
session_start();
header('Content-Type: application/json; charset=utf-8');
if(empty($_SESSION['id'])) {
    echo json_encode(['status'=>'error','message'=>'Not authenticated']); exit;
}
include "config.php"; 

try {
    $school_token = $_POST['school_token'] ?? '';
    $machine_id = trim($_POST['machine_id'] ?? '');

    if (!$school_token || !$machine_id) {
        echo json_encode(['status'=>'error','message'=>'All fields are required']); exit;
    }

    if (strlen($machine_id) > 100) $machine_id = substr($machine_id, 0, 100);

    $stmt = $pdo->prepare("INSERT INTO school_registered_rfid_machines (school_token, machine_id) VALUES (?, ?)");
    $ok = $stmt->execute([$school_token, $machine_id]);

    if ($ok) {
        echo json_encode(['status'=>'success','message'=>'Gate added successfully']);
    } else {
        echo json_encode(['status'=>'error','message'=>'Database error while adding']);
    }
} catch (Exception $ex) {
    error_log("gates_add error: ".$ex->getMessage());
    echo json_encode(['status'=>'error','message'=>'Server error']);
} ?>