<?php
session_start();
header('Content-Type: application/json; charset=utf-8');
if(empty($_SESSION['id'])) {
    echo json_encode(['status'=>'error','message'=>'Not authenticated']); exit;
}
include "config.php"; 

try {
    $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
    $school_token = $_POST['school_token'] ?? '';
    $machine_id = trim($_POST['machine_id'] ?? '');

    if (!$id || !$school_token || !$machine_id) {
        echo json_encode(['status'=>'error','message'=>'Missing parameters']); exit;
    }

    if (strlen($machine_id) > 100) $machine_id = substr($machine_id,0,100);

    $stmt = $pdo->prepare("UPDATE school_registered_rfid_machines SET machine_id = ? WHERE id = ? AND school_token = ?");
    $ok = $stmt->execute([$machine_id, $id, $school_token]);

    if ($ok) {
        if ($stmt->rowCount() > 0) {
            echo json_encode(['status'=>'success','message'=>'Gate updated successfully']);
        } else {
            echo json_encode(['status'=>'error','message'=>'No changes made or gate not found']);
        }
    } else {
        echo json_encode(['status'=>'error','message'=>'Database error while updating']);
    }
} catch (Exception $ex) {
    error_log("gates_update error: ".$ex->getMessage());
    echo json_encode(['status'=>'error','message'=>'Server error']);
} ?>