<?php
header('Content-Type: application/json; charset=utf-8');
require 'config.php';
session_start();

try {
    if (empty($_SESSION['id'])) throw new Exception('Unauthorized');

    $student_id = isset($_GET['student_id']) ? (int)$_GET['student_id'] : 0;
    if (!$student_id) {
        echo json_encode(['assigned' => []]);
        exit;
    }

    $sql = "SELECT sab.id AS assigned_id, sab.book_id AS copy_code, sab.pickup_date, sab.supposed_submit_date, sab.actual_submit_date, 
        COALESCE(sab.status, '') AS sab_status, bc.book_id AS book_id, b.name AS book_name, b.author, b.image FROM student_assigned_books sab
      JOIN book_copies bc ON sab.book_id = bc.copy_code JOIN books b ON bc.book_id = b.id WHERE sab.student_id = :sid ORDER BY sab.pickup_date DESC";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':sid' => $student_id]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['assigned' => $rows]);
    exit;

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['error' => $e->getMessage()]);
    exit;
} ?>