<?php
header('Content-Type: application/json');
require 'config.php';
session_start();

if (empty($_SESSION['id'])) {
    echo json_encode([]);
    exit;
}
$student_id = (int)($_GET['student_id'] ?? 0);
if (!$student_id) {
    echo json_encode([]);
    exit;
}

$school = $_SESSION['school'];
$stmt   = $pdo->prepare("SELECT token FROM listed_school WHERE school = :school LIMIT 1");
$stmt->execute([':school' => $school]);
$row    = $stmt->fetch(PDO::FETCH_ASSOC);
$schoolToken= $row['token'] ?? '';

if (!$schoolToken) {
    echo json_encode([]);
    exit;
}

$chk = $pdo->prepare("SELECT id FROM students_temp WHERE id = :id AND school_token = :token LIMIT 1");
$chk->execute([':id' => $student_id, ':token' => $schoolToken]);
if (!$chk->fetch(PDO::FETCH_ASSOC)) {
    echo json_encode([]);
    exit;
}

$sql = "SELECT id, student_id, machine_id, punch_id, punch_time, punch_status FROM student_attendance_logs WHERE student_id = :sid ORDER BY punch_time ASC";
$stmt = $pdo->prepare($sql);
$stmt->execute([':sid' => $student_id]);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode($rows); ?>