<?php
header('Content-Type: application/json');
require 'config.php';
session_start();

try {
    if (empty($_SESSION['id'])) throw new Exception('Unauthorized');

    $student_id = isset($_GET['student_id']) ? (int)$_GET['student_id'] : 0;

    $adminSchool = isset($_SESSION['school']) ? $_SESSION['school'] : null;
    $adminSchoolId = null;
    if ($adminSchool) {
        $st = $pdo->prepare("SELECT id FROM listed_school WHERE school = :school LIMIT 1");
        $st->execute([':school' => $adminSchool]);
        $srow = $st->fetch(PDO::FETCH_ASSOC);
        $adminSchoolId = isset($srow['id']) ? (int)$srow['id'] : null;
    }

    $excludedBookIds = [];
    if ($student_id) {
        $sql = "SELECT DISTINCT bc.book_id FROM student_assigned_books sab JOIN book_copies bc ON sab.book_id = bc.copy_code WHERE sab.student_id = :sid AND (sab.actual_submit_date IS NULL OR sab.actual_submit_date = '' )";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([':sid' => $student_id]);
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        foreach ($rows as $r) {
            $excludedBookIds[] = (int)$r['book_id'];
        }
    }

    $params = [];
    $whereNotIn = '';
    if (!empty($excludedBookIds)) {
        $placeholders = implode(',', array_fill(0, count($excludedBookIds), '?'));
        $whereNotIn = " AND b.id NOT IN ($placeholders) ";
        $params = $excludedBookIds;
    }
    $whereSchool = '';
    if ($adminSchoolId) {
        $whereSchool = " AND b.school_id = ? ";
        $params[] = $adminSchoolId;
    }

    $sql = "SELECT b.id, b.name, b.des, b.author, b.image, COUNT(bc.id) AS available_copies FROM books b JOIN book_copies bc ON bc.book_id = b.id AND bc.status = 'available' WHERE 1=1 $whereNotIn $whereSchool GROUP BY b.id HAVING available_copies > 0 ORDER BY b.name";
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $available = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $assigned = [];
    if ($student_id) {
        $sql2 = "SELECT sab.id AS assigned_id, sab.book_id AS copy_code, sab.pickup_date, sab.supposed_submit_date, sab.actual_submit_date, bc.book_id 
        AS book_id, b.name AS book_name, b.author, b.image FROM student_assigned_books sab JOIN book_copies bc ON sab.book_id = bc.copy_code JOIN 
        books b ON bc.book_id = b.id WHERE sab.student_id = :sid ORDER BY sab.pickup_date DESC";
        $s2 = $pdo->prepare($sql2);
        $s2->execute([':sid' => $student_id]);
        $assigned = $s2->fetchAll(PDO::FETCH_ASSOC);
    }

    echo json_encode(['available_books' => $available, 'assigned' => $assigned]);
    exit;

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['error' => $e->getMessage()]);
    exit;
} ?>