<?php
session_start();
if(empty($_SESSION['id'])){ echo '<script>window.location.href="signin.php"</script>'; }
include "config.php";
include 'headerlink.php';  ?>

<style>
    .calendar-grid .d-flex > div { box-sizing:border-box; padding:6px; }
    #addCalendarWrap .h-100 { transition: background .12s ease; }
</style>

    <div id="main-wrapper" class="wallet-open active">
	
        <!--Nav header-->
        <div class="nav-header">
            <a href="dashboard.php" class="brand-logo">
				<!-- <svg class="logo-abbr" width="40" height="40" viewBox="0 0 48 54" fill="none" xmlns="http://www.w3.org/2000/svg">
					<rect y="3" width="48" height="48" rx="16" fill="#FB7D5B"></rect>
					<path d="M28.964 35.536H19.532L18.02 40H11.576L20.72 14.728H27.848L36.992 40H30.476L28.964 35.536ZM27.38 30.784L24.248 21.532L21.152 30.784H27.38Z" fill="white"></path>
				</svg> -->
				<div class="brand-title">
					<h4 class="fw-bold text-white">Kolkata Dealer</h4>
				</div> 
            </a>
            <div class="nav-control">
                <div class="hamburger">
                    <span class="line"></span><span class="line"></span><span class="line"></span>
					<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
						<rect x="22" y="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="11" y="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="11" y="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect y="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="22" y="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect y="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
					</svg>		
                </div>
            </div>
        </div>
        <!--/Nav header-->
		
		<!-- header -->
		<div class="header">
			<div class="header-content">
				<nav class="navbar navbar-expand">
					<div class="collapse navbar-collapse justify-content-between">
						<div class="header-left">
							<div class="dashboard_bar">Holiday List</div>
						</div>
						<?php include "header.php"; ?>
					</div>
				</nav>
			</div>
		</div>
		<!-- /header -->
		<?php include "sidebar.php"; ?>
		

        <!--Content body-->
		<div class="content-body">
			<div class="container-fluid">
                <div class="row mb-3">
                    <div class="col-12">
                        <div class="col-12 d-flex justify-content-between align-items-center mb-4">
                            <div>
                                <button id="toggleList" class="btn btn-outline-secondary btn-sm me-2 fw-bold active"><i class="bi bi-list"></i> List</button>
                                <button id="toggleCalendar" class="btn btn-outline-secondary btn-sm fw-bold"><i class="bi bi-calendar"></i> Calendar</button>
                            </div>
                            <div>
                                <button id="openAddModal" class="btn btn-primary btn-sm fw-bold"><i class="bi bi-plus-circle"></i> Add Holiday</button>
                            </div>
                        </div>
                        <div class="col-12">
                            <!-- List view -->
                            <div id="listView" class="row">
                                <div class="col-lg-6">
                                    <div class="card p-3 rounded-4 shadow-sm">
                                        <h6 class="mb-3">Today / Upcoming</h6>
                                        <div id="todayUpcoming" class="mb-2"></div>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="card p-3 rounded-4 shadow-sm">
                                        <h6 class="mb-3">This Month</h6>
                                        <div id="monthList"></div>
                                    </div>
                                </div>
                            </div>
                            <!-- /List view -->
                            <!-- Calendar view -->
                            <div id="calendarView" class="row" style="display:none;">
                                <div class="col-12">
                                    <div class="card p-3 rounded-4 shadow-sm">
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <div>
                                                <button id="calPrev" class="btn btn-outline-secondary btn-sm" disabled><i class="bi bi-chevron-left"></i></button>
                                                <button id="calNext" class="btn btn-outline-secondary btn-sm ms-2"><i class="bi bi-chevron-right"></i></button>
                                            </div>
                                            <div>
                                                <span id="calTitle" class="fw-bold"></span>
                                            </div>
                                        </div>
                                        <div class="row g-3">
                                            <div class="col-md-6">
                                                <div id="calLeft"></div>
                                            </div>
                                            <div class="col-md-6">
                                                <div id="calRight"></div>
                                            </div>
                                        </div>
                                        <hr>
                                        <div id="monthHolidayList" class="mt-3"></div>
                                    </div>
                                </div>
                            </div>
                            <!-- /Calendar view -->
                        </div>
                    </div>
                </div>
                <!-- Add Holiday Modal -->
                <div class="modal fade" id="addHolidayModal" tabindex="-1">
                    <div class="modal-dialog modal-xl modal-dialog-centered">
                        <div class="modal-content rounded-4 shadow-sm">
                            <div class="modal-header">
                                <h5 class="modal-title">Add Holidays (select dates / ranges)</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" id="addModalClose"></button>
                            </div>
                            <div class="modal-body">
                                <div class="row g-3">
                                    <div class="col-md-8">
                                        <div class="d-flex justify-content-between mb-2">
                                            <div>
                                                <select id="addYear" class="form-select form-select-sm d-inline-block" style="width:auto;"></select>
                                                <select id="addMonth" class="form-select form-select-sm d-inline-block ms-2" style="width:auto;"></select>
                                            </div>
                                            <div>
                                                <small class="text-muted ms-auto">Select a start date then an end date to add a range, or drag to multi-select. Click 'Add Selection' to append.</small>
                                            </div>
                                        </div>
                                        <div id="addCalendarWrap" class="border rounded p-2" style="min-height:420px;"></div>
                                    </div>
                                    <div class="col-md-4">
                                        <div>
                                            <h6>Selections</h6>
                                            <div id="selectionsList" class="mb-3"></div>

                                            <div class="mb-3">
                                                <label class="form-label">Holiday Name (will be applied per selection individually)</label>
                                                <input id="selectionName" class="form-control form-control-sm" placeholder="Holiday name for current selection">
                                            </div>
                                            <div class="d-flex gap-2">
                                                <button id="addSelectionBtn" class="btn btn-outline-primary btn-sm">Add Selection</button>
                                                <button id="saveHolidaysBtn" class="btn btn-primary btn-sm">Save Holidays</button>
                                                <button id="clearSelectionsBtn" class="btn btn-outline-secondary btn-sm">Clear</button>
                                            </div>
                                            <div class="mt-3 text-muted small">After adding selections you can remove or edit names before saving.</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /Add Holiday Modal -->
			</div>
		</div>

		<?php include "footer.php" ?>

	</div>
    
<!-- All necessary scripts are here -->
<script>
    document.addEventListener('DOMContentLoaded', function(){
        function toast(msg, bg='#28a745'){ Toastify({ text: msg, backgroundColor: bg, gravity:'top', position:'center' }).showToast(); }

        const toggleList = document.getElementById('toggleList');
        const toggleCal = document.getElementById('toggleCalendar');
        const listView = document.getElementById('listView');
        const calView = document.getElementById('calendarView');
        const calLeft = document.getElementById('calLeft');
        const calRight = document.getElementById('calRight');
        const calTitle = document.getElementById('calTitle');
        const calNext = document.getElementById('calNext');
        const calPrev = document.getElementById('calPrev');
        const monthList = document.getElementById('monthList');
        const todayUpcoming = document.getElementById('todayUpcoming');
        const monthHolidayList = document.getElementById('monthHolidayList');

        const openAddModalBtn = document.getElementById('openAddModal');
        const addModalEl = document.getElementById('addHolidayModal');
        const addModal = new bootstrap.Modal(addModalEl);
        const addYear = document.getElementById('addYear');
        const addMonth = document.getElementById('addMonth');
        const addCalendarWrap = document.getElementById('addCalendarWrap');
        const selectionsList = document.getElementById('selectionsList');
        const selectionNameInput = document.getElementById('selectionName');
        const addSelectionBtn = document.getElementById('addSelectionBtn');
        const saveHolidaysBtn = document.getElementById('saveHolidaysBtn');
        const clearSelectionsBtn = document.getElementById('clearSelectionsBtn');
        const addModalClose = document.getElementById('addModalClose');

        let currentDate = new Date(); 
        let leftDate = new Date(currentDate.getFullYear(), currentDate.getMonth(), 1);
        let rightDate = new Date(leftDate.getFullYear(), leftDate.getMonth()+1, 1);
        let holidays = []; 
        let selections = []; 
        let tempSelection = null; 
        let isMouseDown = false;

        // helper date formatting
        function ymd(d){ 
            const y = d.getFullYear(), m = (d.getMonth()+1), dd = d.getDate();
            return y+'-'+(m<10?'0':'')+m+'-'+(dd<10?'0':'')+dd;
        }
        function formatReadable(d){
            const dt = new Date(d);
            return dt.toLocaleDateString(undefined, { year:'numeric', month:'short', day:'numeric' });
        }

        // fetch holidays for a date range
        async function fetchHolidays(from, to){
            try {
                const res = await fetch(`get_holidays.php?from=${from}&to=${to}`);
                const j = await res.json();
                return j.holidays || [];
            } catch (e) {
                console.error(e);
                return [];
            }
        }

        // load initial list & calendar data (current month & next)
        async function reloadAll(){
            const leftFirst = new Date(leftDate.getFullYear(), leftDate.getMonth(), 1);
            const rightLast = new Date(rightDate.getFullYear(), rightDate.getMonth()+1, 0);
            const from = ymd(leftFirst);
            const to = ymd(rightLast);
            holidays = await fetchHolidays(from, to);
            renderCalendar();
            renderListView();
        }

        // Toggle views
        toggleList.addEventListener('click', () => {
            listView.style.display = ''; calView.style.display = 'none';
            toggleList.classList.add('active'); toggleCal.classList.remove('active');
        });
        toggleCal.addEventListener('click', () => {
            listView.style.display = 'none'; calView.style.display = '';
            toggleList.classList.remove('active'); toggleCal.classList.add('active');
        });

        // Calendar navigation (only forward allowed for add modal requirement; but for main view we can allow prev if in same year/month?)
        calPrev.addEventListener('click', () => {
            leftDate = new Date(leftDate.getFullYear(), leftDate.getMonth()-1, 1);
            rightDate = new Date(leftDate.getFullYear(), leftDate.getMonth()+1, 1);
            reloadAll();
        });
        calNext.addEventListener('click', () => {
            leftDate = new Date(leftDate.getFullYear(), leftDate.getMonth()+1, 1);
            rightDate = new Date(leftDate.getFullYear(), leftDate.getMonth()+1, 1);
            rightDate = new Date(leftDate.getFullYear(), leftDate.getMonth()+1, 1);
            reloadAll();
        });

        // render calendar for leftDate & rightDate
        function renderCalendar(){
            calTitle.textContent = leftDate.toLocaleString(undefined, { month:'long', year:'numeric' }) + ' — ' + rightDate.toLocaleString(undefined, { month:'long', year:'numeric' });

            function buildMonthContainer(date){
                const y = date.getFullYear(), m = date.getMonth();
                const firstDay = new Date(y,m,1);
                const lastDay = new Date(y,m+1,0);
                const startWeekday = firstDay.getDay(); // 0..6
                const total = lastDay.getDate();

                const wrap = document.createElement('div');
                wrap.className = 'p-3 border rounded';
                const title = document.createElement('div');
                title.className = 'mb-2 fw-bold';
                title.textContent = date.toLocaleString(undefined,{ month:'long', year:'numeric' });
                wrap.appendChild(title);

                const table = document.createElement('div');
                table.className = 'calendar-grid';
                const headerRow = document.createElement('div');
                headerRow.className = 'd-flex';
                ['Sun','Mon','Tue','Wed','Thu','Fri','Sat'].forEach(h=>{
                    const cell = document.createElement('div');
                    cell.className = 'flex-fill text-center small text-muted';
                    cell.style.width = 'calc(100%/7)';
                    cell.textContent = h;
                    headerRow.appendChild(cell);
                });
                wrap.appendChild(headerRow);

                const grid = document.createElement('div');
                grid.className = 'd-flex flex-wrap';
                grid.style.minHeight = '200px';
                for(let i=0;i<startWeekday;i++){
                    const empty = document.createElement('div');
                    empty.style.width = 'calc(100%/7)';
                    empty.style.height = '80px';
                    grid.appendChild(empty);
                }
                for(let d=1; d<=total; d++){
                    const dt = new Date(y,m,d);
                    const cell = document.createElement('div');
                    cell.style.width = 'calc(100%/7)';
                    cell.style.height = '80px';
                    cell.className = 'p-1';
                    const inner = document.createElement('div');
                    inner.className = 'h-100 p-2 rounded position-relative';
                    inner.style.cursor = 'default';

                    const dayNum = document.createElement('div');
                    dayNum.className = 'small text-muted';
                    dayNum.textContent = d;
                    inner.appendChild(dayNum);

                    const dayStr = ymd(dt);
                    const dayHols = holidays.filter(h => dayStr >= h.start_date && dayStr <= h.end_date);
                    if (dayHols.length) {
                        const pill = document.createElement('div');
                        pill.className = 'badge bg-warning text-dark small position-absolute';
                        pill.style.bottom = '6px'; pill.style.left = '6px';
                        pill.textContent = dayHols[0].name + (dayHols[0].start_date !== dayHols[0].end_date ? ' (range)' : '');
                        pill.title = dayHols.map(x=>x.name + (x.start_date!==x.end_date ? ' ['+x.start_date+'→'+x.end_date+']' : '')).join('\n');
                        inner.appendChild(pill);
                    }
                    cell.appendChild(inner);
                    grid.appendChild(cell);
                }
                wrap.appendChild(grid);
                return wrap;
            }

            calLeft.innerHTML = ''; calRight.innerHTML = '';
            calLeft.appendChild(buildMonthContainer(leftDate));
            calRight.appendChild(buildMonthContainer(rightDate));
            renderMonthHolidayList();
        }

        // Render List View: today/upcoming and this month's list
        function renderListView(){
            const today = new Date();
            const y = today.getFullYear(), m = today.getMonth();
            const first = new Date(y,m,1);
            const last = new Date(y,m+1,0);

            fetchHolidays(ymd(first), ymd(last)).then(rows=>{
                let html = '';
                if (!rows || !rows.length) {
                    html = '<div class="text-muted">No holidays this month.</div>';
                } else {
                    html = '<ul class="list-group">';
                    rows.forEach(r=>{
                        if (r.start_date === r.end_date) {
                            html += `<li class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <div class="fw-bold">${r.name}</div>
                                <div class="small text-muted">${formatReadable(r.start_date)}</div>
                            </div>
                            </li>`;
                        } else {
                            html += `<li class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <div class="fw-bold">${r.name}</div>
                                <div class="small text-muted">${formatReadable(r.start_date)} — ${formatReadable(r.end_date)}</div>
                            </div>
                            </li>`;
                        }
                    });
                    html += '</ul>';
                }
                monthList.innerHTML = html;
            });

            // today/upcoming: show today if any, else next two upcoming
            const from = ymd(new Date());
            const to = ymd(new Date(new Date().getFullYear(), new Date().getMonth()+6, 0)); 
            fetchHolidays(from, to).then(rows=>{
                if (!rows || !rows.length) {
                    todayUpcoming.innerHTML = '<div class="text-muted">No upcoming holidays.</div>';
                    return;
                }
                const todayStr = ymd(new Date());
                const todays = rows.filter(r => todayStr >= r.start_date && todayStr <= r.end_date);
                let html = '';
                if (todays.length) {
                    html += '<div><strong>Today</strong></div>';
                    todays.forEach(r => {
                        html += `<div class="mb-3 p-3 rounded">
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="fw-bold text-dark">${r.name}</div>
                                <div class="text-muted small">${formatReadable(r.start_date)}${r.start_date!==r.end_date?' — '+formatReadable(r.end_date):''}</div>
                            </div>
                        </div>`;
                    });
                } else {
                    const upcoming = rows.filter(r => r.start_date >= todayStr).sort((a,b)=>a.start_date.localeCompare(b.start_date));
                    const two = upcoming.slice(0,2);
                    if (two.length){
                        html += '<div class="mb-3 px-3"><strong>Upcoming Holidays -</strong></div>';
                        two.forEach(r=>{
                            html += `<div class="mb-3 p-3 rounded">
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="fw-bold text-dark">${r.name}</div>
                                <div class="text-muted small">${formatReadable(r.start_date)}${r.start_date!==r.end_date?' — '+formatReadable(r.end_date):''}</div>
                            </div>
                            </div>`;
                        });
                    } else {
                        html = '<div class="text-muted">No upcoming holidays.</div>';
                    }
                }
                todayUpcoming.innerHTML = html;
            });
        }

        function renderMonthHolidayList(){
            // show holidays for leftDate's month
            const y = leftDate.getFullYear(), m = leftDate.getMonth();
            const first = ymd(new Date(y,m,1));
            const last = ymd(new Date(y,m+1,0));
            fetchHolidays(first, last).then(rows=>{
                if (!rows.length) {
                    monthHolidayList.innerHTML = '<div class="text-muted">No holidays for this month.</div>';
                    return;
                }
                let html = '<ul class="list-group">';
                rows.forEach(r=>{
                    html += `<li class="list-group-item d-flex justify-content-between align-items-center">
                    <div>
                        <div class="fw-bold">${r.name}</div>
                        <div class="small text-muted">${formatReadable(r.start_date)}${r.start_date!==r.end_date?' — '+formatReadable(r.end_date):''}</div>
                    </div>
                    </li>`;
                });
                html += '</ul>';
                monthHolidayList.innerHTML = html;
            });
        }

        // -------------------- Add Modal Calendar (selection UI) --------------------
        // populate year/month selects (only current + forward years)
        function initAddModalSelectors(){
            addYear.innerHTML = '';
            const cy = currentDate.getFullYear();
            for(let y = cy; y <= cy+2; y++){
                const opt = document.createElement('option'); opt.value = y; opt.textContent = y;
                addYear.appendChild(opt);
            }
            addMonth.innerHTML = '';
            for(let m=0;m<12;m++){
                const opt = document.createElement('option'); opt.value = m; opt.textContent = new Date(0,m,1).toLocaleString(undefined,{month:'long'});
                addMonth.appendChild(opt);
            }
            addYear.value = currentDate.getFullYear();
            addMonth.value = currentDate.getMonth();
            addYear.addEventListener('change', renderAddCalendar);
            addMonth.addEventListener('change', renderAddCalendar);
        }

        // render the add modal calendar for currently selected year & month (single month)
        function renderAddCalendar(){
            const y = parseInt(addYear.value,10);
            const m = parseInt(addMonth.value,10);
            addCalendarWrap.innerHTML = '';
            const monthFirst = new Date(y,m,1);
            const lastDate = new Date(y,m+1,0).getDate();
            const startWeekday = monthFirst.getDay();
            const wrap = document.createElement('div');
            const title = document.createElement('div'); title.className='mb-2 fw-bold'; title.textContent = monthFirst.toLocaleString(undefined,{month:'long',year:'numeric'});
            wrap.appendChild(title);
            const headerRow = document.createElement('div'); headerRow.className='d-flex';
            ['Sun','Mon','Tue','Wed','Thu','Fri','Sat'].forEach(h=>{ const c=document.createElement('div'); c.className='flex-fill text-center small text-muted'; c.style.width='calc(100%/7)'; c.textContent=h; headerRow.appendChild(c); });
            wrap.appendChild(headerRow);

            const grid = document.createElement('div'); grid.className='d-flex flex-wrap'; grid.style.minHeight='360px';

            for(let i=0;i<startWeekday;i++){ const e=document.createElement('div'); e.style.width='calc(100%/7)'; e.style.height='80px'; grid.appendChild(e); }
            for(let d=1; d<=lastDate; d++){
                const cell = document.createElement('div'); cell.style.width='calc(100%/7)'; cell.style.height='80px'; cell.className='p-1';
                cell.dataset.date = y+'-'+(m<9?('0'+(m+1)):(m+1))+'-'+(d<10?('0'+d):d);
                const inner = document.createElement('div'); inner.className='h-100 p-2 rounded position-relative border';
                inner.style.cursor='pointer';
                inner.dataset.date = cell.dataset.date;
                inner.innerHTML = `<div class="small text-muted">${d}</div>`;
                const idxSel = selections.findIndex(s => cell.dataset.date >= s.start && cell.dataset.date <= s.end);
                if (idxSel !== -1) {
                    inner.style.background = '#ffe8cc';
                }
                cell.appendChild(inner);
                grid.appendChild(cell);

                inner.addEventListener('mousedown', (ev)=>{
                    isMouseDown = true;
                    tempSelection = { start: inner.dataset.date, end: inner.dataset.date };
                    inner.classList.add('bg-light');
                });
                inner.addEventListener('mouseenter', (ev)=>{
                    if (isMouseDown && tempSelection) {
                        tempSelection.end = inner.dataset.date;
                        highlightTempRange(y,m,tempSelection);
                    }
                });
                inner.addEventListener('mouseup', (ev)=>{
                    isMouseDown = false;
                    if (tempSelection) {
                        const s = tempSelection.start, e = tempSelection.end;
                        if (s > e) { tempSelection.start = e; tempSelection.end = s; }
                        showTempSelection(tempSelection);
                    }
                });
                // single click to add single date selection
                inner.addEventListener('click', (ev)=>{
                    const date = inner.dataset.date;
                    tempSelection = { start: date, end: date };
                    showTempSelection(tempSelection);
                    // tempSelection = null;
                });
            }

            wrap.appendChild(grid);
            addCalendarWrap.appendChild(wrap);
            renderSelectionsHighlights();
        }

        function highlightTempRange(y,m,range){
            Array.from(addCalendarWrap.querySelectorAll('[data-date]')).forEach(el=>{
                const dt = el.dataset.date;
                const inner = el.querySelector('.h-100');
                if (!inner) return;
                if (dt >= range.start && dt <= range.end) {
                    inner.style.background = '#e6f7ff';
                } else {
                    inner.style.background = '';
                }
            });
        }

        function showTempSelection(range){
            selectionNameInput.value = selectionNameInput.value || '';
            tempSelection = { start: range.start, end: range.end };
            renderSelectionsHighlights();
            updateSelectorsDisabled();
        }

        function renderSelectionsHighlights(){
            Array.from(addCalendarWrap.querySelectorAll('[data-date]')).forEach(el=>{
                const dt = el.dataset.date;
                const inner = el.querySelector('.h-100');
                if (!inner) return;
                const inSel = selections.some(s => dt >= s.start && dt <= s.end);
                if (inSel) {
                    inner.style.background = '#ffe8cc';
                    inner.title = selections.filter(s=>dt>=s.start && dt<=s.end).map(s=>s.name||'Holiday').join(', ');
                } else if (tempSelection && dt >= tempSelection.start && dt <= tempSelection.end) {
                    inner.style.background = '#e6f7ff';
                } else {
                    inner.style.background = '';
                    inner.title = '';
                }
            });
        }

        // add current tempSelection to selections array with name
        addSelectionBtn.addEventListener('click', ()=>{
            if (!tempSelection) { toast('Select a date or range first','#e74c3c'); return; }
            const name = selectionNameInput.value.trim();
            if (!name) { toast('Enter holiday name for this selection','#e74c3c'); return; }

            const s = tempSelection.start, e = tempSelection.end;
            selections.push({ start:s, end:e, name:name });
            tempSelection = null;
            selectionNameInput.value = '';
            renderSelectionsList();
            renderAddCalendar(); 
            updateSelectorsDisabled();
        });

        // render selections list on right panel
        function renderSelectionsList(){
            selectionsList.innerHTML = '';
            if (!selections.length) { selectionsList.innerHTML = '<div class="text-muted small">No selections yet.</div>'; return; }
            const ul = document.createElement('div');
            selections.forEach((s,idx)=>{
                const el = document.createElement('div');
                el.className = 'mb-2 border p-2 rounded';
                el.innerHTML = `<div class="d-flex justify-content-between align-items-start">
                    <div>
                        <div class="fw-bold">${escapeHtml(s.name)}</div>
                        <div class="small text-muted">${formatReadable(s.start)}${s.start!==s.end?' — '+formatReadable(s.end):''}</div>
                    </div>
                    <div>
                        <button data-idx="${idx}" class="btn btn-sm btn-outline-danger remove-selection-btn">Remove</button>
                    </div>
                </div>`;
                ul.appendChild(el);
            });
            selectionsList.appendChild(ul);
            // bind remove buttons
            Array.from(document.querySelectorAll('.remove-selection-btn')).forEach(btn=>{
                btn.addEventListener('click',(ev)=>{
                    const idx = parseInt(btn.dataset.idx,10);
                    if (!isNaN(idx)) {
                        selections.splice(idx,1);
                        renderSelectionsList();
                        renderAddCalendar();
                        updateSelectorsDisabled();
                    }
                });
            });
        }

        function escapeHtml(s){ return s ? s.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;') : ''; }

        // clear selections
        clearSelectionsBtn.addEventListener('click', ()=>{
            selections = []; tempSelection = null; selectionNameInput.value = '';
            renderSelectionsList(); renderAddCalendar(); updateSelectorsDisabled();
        });

        // Save holidays to server
        saveHolidaysBtn.addEventListener('click', async ()=>{
            if (!selections.length) { toast('Add selections before saving','#e74c3c'); return; }
            for(const s of selections){
                if (!s.name || !s.start) { toast('Each selection must have a name and dates','#e74c3c'); return; }
            }
            saveHolidaysBtn.disabled = true;
            saveHolidaysBtn.textContent = 'Saving...';
            toast('Saving holidays — please wait', '#3498db');
            try {
                const payload = { entries: selections };
                const form = new FormData();
                form.append('entries', JSON.stringify(selections));
                const res = await fetch('add_holidays.php', { method:'POST', body: form });
                const j = await res.json();
                if (j && j.status === 'success') {
                    toast('Holidays saved', '#28a745');
                    addModal.hide();
                    setTimeout(()=>{ location.reload(); }, 1000);
                } else {
                    toast(j.message || 'Save failed', '#e74c3c');
                }
            } catch (e) {
                console.error(e);
                toast('Server error', '#e74c3c');
            } finally {
                saveHolidaysBtn.disabled = false;
                saveHolidaysBtn.textContent = 'Save Holidays';
            }
        });
        // disable month/year selectors if any selection exists with a name
        function updateSelectorsDisabled(){
            const shouldDisable = selections.length > 0;
            addYear.disabled = shouldDisable;
            addMonth.disabled = shouldDisable;
            addSelectionBtn.disabled = !tempSelection;
        }

        // open add modal
        openAddModalBtn.addEventListener('click', ()=>{
            selections = []; tempSelection = null; selectionNameInput.value = '';
            initAddModalSelectors();
            renderAddCalendar();
            renderSelectionsList();
            updateSelectorsDisabled();
            addModal.show();
        });
        // close handlers: re-enable selectors
        addModalClose.addEventListener('click', ()=>{
            selections = []; tempSelection = null;
            updateSelectorsDisabled();
        });

        // init initial left/right months to current and next
        leftDate = new Date();
        leftDate.setDate(1);
        rightDate = new Date(leftDate.getFullYear(), leftDate.getMonth()+1, 1);
        reloadAll();
        addModalEl.addEventListener('shown.bs.modal', ()=>{ renderAddCalendar(); renderSelectionsList(); });
    });
</script>
<?php include "footerlink.php"; ?>