<?php
session_start();
require_once 'config.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Invalid request'
    ]);
    exit;
}

$email    = trim($_POST['email']    ?? '');
$password = $_POST['password']      ?? '';

if (empty($email) || empty($password)) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Please provide both email and password'
    ]);
    exit;
}

try {
    $stmt = $pdo->prepare("SELECT id, name, email, password, school, status FROM admin WHERE email = :email LIMIT 1");
    $stmt->execute([
        ':email' => $email
    ]);
    $user = $stmt->fetch();

    if (!$user) {
        echo json_encode([
            'status'  => 'error',
            'message' => 'Invalid email or password'
        ]);
        exit;
    }
    if ($user['status'] !== 'Active') {
        echo json_encode([
            'status'  => 'error',
            'message' => 'Your account is inactive. Please contact the higher-ups for access.'
        ]);
        exit;
    }
    if (!password_verify($password, $user['password'])) {
        echo json_encode([
            'status'  => 'error',
            'message' => 'Invalid email or password'
        ]);
        exit;
    }

    $_SESSION['id']    = $user['id'];
    $_SESSION['name']  = $user['name'];
    $_SESSION['email'] = $user['email'];
    $_SESSION['school'] = $user['school'];

    echo json_encode([
        'status'  => 'success',
        'message' => 'Login successful! Redirecting...'
    ]);
    exit;

} catch (PDOException $e) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Server error. Please try again later.'
    ]);
    exit;
} ?>