<?php
require 'config.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);
if (empty($data['id'])) {
  echo json_encode(['success'=>false,'message'=>'Invalid ID']);
  exit;
}

try {
  $stmt = $pdo->prepare("DELETE FROM students_temp WHERE id = :id");
  $stmt->execute([':id'=>$data['id']]);

  echo json_encode(['success'=>true,'message'=>'Student rejected and removed']);
} catch (Exception $e) {
  echo json_encode(['success'=>false,'message'=>'Error: '.$e->getMessage()]);
}

try {
  $sts = 'Rejected'; 

  $sql = "UPDATE students_temp SET status = :sts WHERE id = :id";
  $stmt = $pdo->prepare($sql);
  $stmt->execute([':sts'=>$sts,':id'=>$data['id']]);

  $stmt = $pdo->prepare("SELECT email,name FROM students_temp WHERE id = :id");
  $stmt->execute([':id'=>$data['id']]);
  $user = $stmt->fetch();

  $to = $user['email'];
  $sub = "Your registration has been rejected";
  $msg = "Hi {$user['name']},\n\nYour registration is rejected as the data you provided is not looking genuine!";
  mail($to, $sub, $msg);

  echo json_encode(['success'=>true,'message'=>'Student rejected & email sent']);
} catch (Exception $e) {
  echo json_encode(['success'=>false,'message'=>'Error: '.$e->getMessage()]);
} ?>