<?php
header('Content-Type: application/json');
require 'config.php';
session_start();

if (empty($_SESSION['id'])) {
    echo json_encode(['ok' => false, 'msg' => 'Not authenticated']);
    exit;
}

$student_id = (int)($_POST['student_id'] ?? 0);
if (!$student_id) {
    echo json_encode(['ok' => false, 'msg' => 'Invalid student']);
    exit;
}

$school = $_SESSION['school'];
$stmt   = $pdo->prepare("SELECT token FROM listed_school WHERE school = :school LIMIT 1");
$stmt->execute([':school' => $school]);
$row        = $stmt->fetch(PDO::FETCH_ASSOC);
$schoolToken= $row['token'] ?? '';

if (!$schoolToken) {
    echo json_encode(['ok'=>false, 'msg'=>'School token not found']);
    exit;
}

$stmt = $pdo->prepare("SELECT is_active FROM students_temp WHERE id = :id AND school_token = :token LIMIT 1");
$stmt->execute([':id' => $student_id, ':token' => $schoolToken]);
$student = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$student) {
    echo json_encode(['ok' => false, 'msg' => 'Student not found']);
    exit;
}

$current = strtolower((string)$student['is_active']);
if ($current === 'active' || $current === '1' || $current === 'true') {
    $new = 'inactive';
} else {
    $new = 'active';
}

$upd = $pdo->prepare("UPDATE students_temp SET is_active = :new WHERE id = :id AND school_token = :token");
$ok = $upd->execute([':new' => $new, ':id' => $student_id, ':token' => $schoolToken]);

if ($ok) {
    echo json_encode(['ok' => true, 'status' => $new]);
} else {
    echo json_encode(['ok' => false, 'msg' => 'Failed to update']);
} ?>