<?php
header('Content-Type: application/json; charset=utf-8');

try {
    include 'config.php';
} catch (Exception $e) {
    echo json_encode(['status' => false, 'message' => 'Server config error.']);
    exit;
}

function json_resp($status, $msg) {
    echo json_encode(['status' => $status, 'message' => $msg]);
    exit;
}
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    json_resp(false, 'Invalid request method.');
}

$admin_id = isset($_POST['admin_id']) ? intval($_POST['admin_id']) : 0;
if ($admin_id <= 0) json_resp(false, 'Invalid teacher ID.');

$name = isset($_POST['name']) ? trim($_POST['name']) : '';
$phone = isset($_POST['phone']) ? trim($_POST['phone']) : '';
$email = isset($_POST['email']) ? trim($_POST['email']) : '';
$address = isset($_POST['address']) ? trim($_POST['address']) : '';

if ($name === '') json_resp(false, 'Name is required.');
if ($email === '' || !filter_var($email, FILTER_VALIDATE_EMAIL)) json_resp(false, 'Valid email is required.');

try {
    $sql = "UPDATE admin SET name = :name, phone = :phone, email = :email, address = :address WHERE id = :id LIMIT 1";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':name' => $name,
        ':phone' => $phone,
        ':email' => $email,
        ':address' => $address,
        ':id' => $admin_id
    ]);

    json_resp(true, 'Profile updated successfully.');
} catch (PDOException $e) {
    if (!empty($dbImagePath) && isset($targetPath) && file_exists($targetPath)) {
        @unlink($targetPath);
    }
    json_resp(false, 'Database error: ' . $e->getMessage());
} ?>