<?php
header('Content-Type: application/json');
session_start();
require 'config.php';

$body   = json_decode(file_get_contents('php://input'), true);
$id     = (int)($body['id'] ?? 0);
$action = $body['action'] ?? '';

if (!$id || !in_array($action, ['approve','reject','provide'])) {
  echo json_encode(['status'=>'error','message'=>'Invalid request']);
  exit;
}

$statusMap = [
  'approve' => 'Approved',
  'reject'  => 'Rejected',
  'provide' => 'Provide Doc'
];
$newStatus = $statusMap[$action];

try {
  $stmt1 = $pdo->prepare("SELECT p.teacher_id, p.created_at, t.email FROM teacher_posted_application p JOIN teachers t ON t.id = p.teacher_id WHERE p.id = :id LIMIT 1");
  $stmt1->execute([':id' => $id]);
  $row = $stmt1->fetch(PDO::FETCH_ASSOC);
  if (!$row) {
    echo json_encode(['status'=>'error','message'=>'Application not found']);
    exit;
  }
  $teacherEmail   = $row['email'];
  $submittedAt    = date('Y-m-d H:i', strtotime($row['created_at']));

  $stmt2 = $pdo->prepare("UPDATE teacher_posted_application SET current_status = :st, approve_reject_time = NOW() WHERE id = :id");
  $stmt2->execute([
    ':st' => $newStatus,
    ':id' => $id
  ]);

  $subject = "Updated Leave Application status";
  $message = "
    Hello,

    Your application submitted on {$submittedAt} has been updated to: {$newStatus}
    You can log in to view more details.

    Best regards,
    Administration Team";

  $headers  = "From: no-reply@yourdomain.com\r\n";
  $headers .= "Reply-To: no-reply@yourdomain.com\r\n";
  $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";

  if (!mail($teacherEmail, $subject, $message, $headers)) {
    echo json_encode([
      'status'  => 'error',
      'message' => "Status updated, but failed to send email to {$teacherEmail}"
    ]);
    exit;
  }

  echo json_encode([
    'status'  => 'success',
    'message' => "Marked “{$newStatus}” and emailed teacher"
  ]);

} catch (PDOException $e) {
  echo json_encode([
    'status'  => 'error',
    'message' => 'DB Error: ' . $e->getMessage()
  ]);
  exit;
} ?>