<?php
// ini_set('display_errors', 1);
// error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');

require_once "config.php";

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method Not Allowed']);
    exit;
}
function respond($status, $message = '') {
    echo json_encode(['status' => $status, 'message' => $message]);
    exit;
}

try {
    $required = ['name','email','address','country','city','state','pin','dob','age','school_token','applied_class'];
    foreach ($required as $field) {
        if (empty($_POST[$field])) {
            respond('false', ucfirst($field) . ' is required');
        }
    }

    $name               = trim($_POST['name']);
    $phone              = trim($_POST['phone'] ?? '');
    $email              = trim($_POST['email']);
    $address            = trim($_POST['address']);
    $country            = trim($_POST['country']);
    $city               = trim($_POST['city']);
    $state              = trim($_POST['state']);
    $pin                = trim($_POST['pin']);
    $dob                = trim($_POST['dob']);
    $age                = trim($_POST['age']);
    $school_token       = trim($_POST['school_token']);
    $applied_class      = trim($_POST['applied_class']);
    $prev_school        = trim($_POST['prev_school']);
    $prev_class         = trim($_POST['prev_class']);
    $marks_got          = trim($_POST['marks_got'] ?? '');
    $out_off            = trim($_POST['out_off'] ?? '');
    $percentage         = trim($_POST['percentage'] ?? '');
    $learning_language  = trim($_POST['learning_language'] ?? '');
    $preferred_language = trim($_POST['preferred_language'] ?? '');
    $status             = 'Pending';
    $applied_at         = date('Y-m-d H:i:s');

    // Check school token
    $stmt = $pdo->prepare("SELECT 1 FROM listed_school WHERE token = :token LIMIT 1");
    $stmt->execute([':token' => $school_token]);
    if (!$stmt->fetch()) {
        respond('false', 'Wrong School Token');
    }

    // Check for duplicate name/email/phone
    $dupSql = "SELECT 1 FROM students_temp WHERE email = :email OR phone = :phone OR name = :name LIMIT 1";
    $dupStmt = $pdo->prepare($dupSql);
    $dupStmt->execute([
        ':email' => $email,
        ':phone' => $phone,
        ':name'  => $name
    ]);
    if ($dupStmt->fetch()) {
        respond('false', 'Student with same name, email or phone already exists');
    }

    // Handle file upload
    $uploadDir = __DIR__ . '/uploads/students';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
        chmod($uploadDir, 0777);
    }
    $imagePath = '';
    if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
        $tmp     = $_FILES['image']['tmp_name'];
        $nameImg = basename($_FILES['image']['name']);
        $safe    = preg_replace('/[^A-Za-z0-9_\-\.]/', '_', $nameImg);
        $target  = "$uploadDir/".time()."_$safe";
        if (move_uploaded_file($tmp, $target)) {
            $imagePath = 'uploads/students/' . basename($target);
        } else {
            respond('false', 'Failed to move uploaded file.');
        }
    }

    $sql = "INSERT INTO students_temp (name, phone, email, address, country, city, state, pin, dob, age, school_token, applied_class, prev_school, prev_class, marks_got, out_off, percentage, learning_language, preferred_language, image, applied_at, status) VALUES (:name, :phone, :email, :address, :country, :city, :state, :pin, :dob, :age, :school_token, :applied_class, :prev_school, :prev_class, :marks_got, :out_off, :percentage, :learning_language, :preferred_language, :image, :applied_at, :status)";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':name'               => $name,
        ':phone'              => $phone,
        ':email'              => $email,
        ':address'            => $address,
        ':country'            => $country,
        ':city'               => $city,
        ':state'              => $state,
        ':pin'                => $pin,
        ':dob'                => $dob,
        ':age'                => $age,
        ':school_token'       => $school_token,
        ':applied_class'      => $applied_class,
        ':prev_school'        => $prev_school,
        ':prev_class'         => $prev_class,
        ':marks_got'          => $marks_got,
        ':out_off'            => $out_off,
        ':percentage'         => $percentage,
        ':learning_language'  => $learning_language,
        ':preferred_language' => $preferred_language,
        ':image'              => $imagePath,
        ':applied_at'         => $applied_at,
        ':status'             => $status
    ]);

    respond('true', 'Thanks for registering, we will soon get back to you.');

} catch (PDOException $e) {
    respond('false', 'DB Error: ' . $e->getMessage());
} ?>