<?php
require 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status'=>'error','message'=>'Invalid request']);
    exit;
}

$name     = trim($_POST['name'] ?? '');
$phone    = trim($_POST['phone'] ?? '');
$email    = trim($_POST['email'] ?? '');
$password = trim($_POST['password'] ?? '');
$school   = trim($_POST['school'] ?? '');
$token    = trim($_POST['token'] ?? '');
$address  = trim($_POST['address'] ?? '');
$status  = 'Active';

if (!$name || !$email || !$password || !$school || !$token) {
    http_response_code(400);
    echo json_encode(['status'=>'error','message'=>'Please fill all required fields']);
    exit;
}
$passHash = password_hash($password, PASSWORD_BCRYPT);

try {
    $stmt = $pdo->prepare("INSERT INTO admin (name, phone, email, password, school, token, address, status) VALUES (:name, :phone, :email, :password, :school, :token, :address, :status)");

    $stmt->execute([
      ':name'     => $name,
      ':phone'    => $phone,
      ':email'    => $email,
      ':password' => $passHash,
      ':school'   => $school,
      ':token'    => $token,
      ':address'  => $address,
      ':status'   => $status
    ]);

    echo json_encode(['status'=>'success','message'=>'Admin account created!']);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status'=>'error','message'=>'Database error']);
} ?>