<?php
session_start();
require_once 'config.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
    exit;
}
if (empty($_SESSION['id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

$email = trim($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';
$name = trim($_POST['name'] ?? 'Mini Superadmin'); 

$permission_add_school = isset($_POST['permission_add_school']) ? (int)$_POST['permission_add_school'] : 0;
$permission_create_admin = isset($_POST['permission_create_admin']) ? (int)$_POST['permission_create_admin'] : 0;
$permission_view_activity = isset($_POST['permission_view_activity']) ? (int)$_POST['permission_view_activity'] : 0;
$permission_create_mini = isset($_POST['permission_create_mini']) ? (int)$_POST['permission_create_mini'] : 0;

if (empty($email) || empty($password)) {
    echo json_encode(['status' => 'error', 'message' => 'Email & password required']);
    exit;
}
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid email']);
    exit;
}

try {
    $stmt = $pdo->prepare("SELECT id FROM superadmin WHERE email = ? LIMIT 1");
    $stmt->execute([$email]);
    if ($stmt->rowCount() > 0) {
        echo json_encode(['status' => 'error', 'message' => 'Email already registered']);
        exit;
    }
    $hashed = password_hash($password, PASSWORD_BCRYPT);

    $stmt = $pdo->prepare("INSERT INTO superadmin (name, email, password, is_mini_superadmin, permission_add_school, permission_create_admin, permission_view_activity, permission_create_mini) VALUES (?, ?, ?, 1, ?, ?, ?, ?)");
    $stmt->execute([$name, $email, $hashed, $permission_add_school, $permission_create_admin, $permission_view_activity, $permission_create_mini]);

    echo json_encode(['status' => 'success', 'message' => 'Mini superadmin created']);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Server error: '.$e->getMessage()]);
} ?>