<?php
require 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'add_school') {
  $school = trim($_POST['school'] ?? '');
  $token  = trim($_POST['token'] ?? '');

  if (!$school || !$token) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Both fields are required.']);
    exit;
  }

  try {
    $check = $pdo->prepare("SELECT id FROM listed_school WHERE school = :school OR token = :token LIMIT 1");
    $check->execute([':school' => $school, ':token' => $token]);
    $exists = $check->fetch(PDO::FETCH_ASSOC);

    if ($exists) {
      http_response_code(409);
      echo json_encode(['status' => 'error', 'message' => 'This school (or token) is already listed.']);
      exit;
    }

    $stmt = $pdo->prepare("INSERT INTO listed_school (school, token) VALUES (:school, :token)");
    $stmt->execute([':school' => $school, ':token' => $token]);
    echo json_encode(['status' => 'success', 'message' => 'School added successfully.']);
  } catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Database error.']);
  }
  exit;
} ?>