<?php
session_start();
require_once 'config.php';
header('Content-Type: application/json');

$email = trim($_GET['email'] ?? '');
if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid email', 'is_mini' => 0]);
    exit;
}

try {
    $stmt = $pdo->prepare("SELECT is_mini_superadmin FROM superadmin WHERE email = ? LIMIT 1");
    $stmt->execute([$email]);
    $row = $stmt->fetch();
    if ($row) {
        echo json_encode(['status' => 'success', 'is_mini' => (int)$row['is_mini_superadmin']]);
    } else {
        echo json_encode(['status' => 'success', 'is_mini' => 0]);
    }
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Server error', 'is_mini' => 0]);
} ?>