<?php
session_start();
if(empty($_SESSION['id'])){ echo '<script>window.location.href="signin.php"</script>'; }
include "config.php";
include 'headerlink.php'; ?>

    <div id="main-wrapper" class="wallet-open active">
	
        <!--Nav header-->
        <div class="nav-header">
            <a href="index.php" class="brand-logo">
				<!-- <svg class="logo-abbr" width="40" height="40" viewBox="0 0 48 54" fill="none" xmlns="http://www.w3.org/2000/svg">
					<rect y="3" width="48" height="48" rx="16" fill="#FB7D5B"></rect>
					<path d="M28.964 35.536H19.532L18.02 40H11.576L20.72 14.728H27.848L36.992 40H30.476L28.964 35.536ZM27.38 30.784L24.248 21.532L21.152 30.784H27.38Z" fill="white"></path>
				</svg> -->
				<div class="brand-title">
					<!-- <svg width="140" height="30" viewBox="0 0 167 30" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M17.964 24.536H8.532L7.02 29H0.576L9.72 3.728H16.848L25.992 29H19.476L17.964 24.536ZM16.38 19.784L13.248 10.532L10.152 19.784H16.38ZM41.051 29L34.931 20.576V29H28.775V2.36H34.931V17.084L41.015 8.912H48.611L40.259 18.992L48.683 29H41.051ZM49.8049 18.92C49.8049 16.856 50.1889 15.044 50.9569 13.484C51.7489 11.924 52.8169 10.724 54.1609 9.884C55.5049 9.044 57.0049 8.624 58.6609 8.624C60.0769 8.624 61.3129 8.912 62.3689 9.488C63.4489 10.064 64.2769 10.82 64.8529 11.756V8.912H71.0089V29H64.8529V26.156C64.2529 27.092 63.4129 27.848 62.3329 28.424C61.2769 29 60.0409 29.288 58.6249 29.288C56.9929 29.288 55.5049 28.868 54.1609 28.028C52.8169 27.164 51.7489 25.952 50.9569 24.392C50.1889 22.808 49.8049 20.984 49.8049 18.92ZM64.8529 18.956C64.8529 17.42 64.4209 16.208 63.5569 15.32C62.7169 14.432 61.6849 13.988 60.4609 13.988C59.2369 13.988 58.1929 14.432 57.3289 15.32C56.4889 16.184 56.0689 17.384 56.0689 18.92C56.0689 20.456 56.4889 21.68 57.3289 22.592C58.1929 23.48 59.2369 23.924 60.4609 23.924C61.6849 23.924 62.7169 23.48 63.5569 22.592C64.4209 21.704 64.8529 20.492 64.8529 18.956ZM74.2385 18.92C74.2385 16.856 74.6225 15.044 75.3905 13.484C76.1825 11.924 77.2505 10.724 78.5945 9.884C79.9385 9.044 81.4385 8.624 83.0945 8.624C84.4145 8.624 85.6145 8.9 86.6945 9.452C87.7985 10.004 88.6625 10.748 89.2865 11.684V2.36H95.4425V29H89.2865V26.12C88.7105 27.08 87.8825 27.848 86.8025 28.424C85.7465 29 84.5105 29.288 83.0945 29.288C81.4385 29.288 79.9385 28.868 78.5945 28.028C77.2505 27.164 76.1825 25.952 75.3905 24.392C74.6225 22.808 74.2385 20.984 74.2385 18.92ZM89.2865 18.956C89.2865 17.42 88.8545 16.208 87.9905 15.32C87.1505 14.432 86.1185 13.988 84.8945 13.988C83.6705 13.988 82.6265 14.432 81.7625 15.32C80.9225 16.184 80.5025 17.384 80.5025 18.92C80.5025 20.456 80.9225 21.68 81.7625 22.592C82.6265 23.48 83.6705 23.924 84.8945 23.924C86.1185 23.924 87.1505 23.48 87.9905 22.592C88.8545 21.704 89.2865 20.492 89.2865 18.956ZM118.832 18.632C118.832 19.208 118.796 19.808 118.724 20.432H104.792C104.888 21.68 105.284 22.64 105.98 23.312C106.7 23.96 107.576 24.284 108.608 24.284C110.144 24.284 111.212 23.636 111.812 22.34H118.364C118.028 23.66 117.416 24.848 116.528 25.904C115.664 26.96 114.572 27.788 113.252 28.388C111.932 28.988 110.456 29.288 108.824 29.288C106.856 29.288 105.104 28.868 103.568 28.028C102.032 27.188 100.832 25.988 99.9681 24.428C99.1041 22.868 98.6721 21.044 98.6721 18.956C98.6721 16.868 99.0921 15.044 99.9321 13.484C100.796 11.924 101.996 10.724 103.532 9.884C105.068 9.044 106.832 8.624 108.824 8.624C110.768 8.624 112.496 9.032 114.008 9.848C115.52 10.664 116.696 11.828 117.536 13.34C118.4 14.852 118.832 16.616 118.832 18.632ZM112.532 17.012C112.532 15.956 112.172 15.116 111.452 14.492C110.732 13.868 109.832 13.556 108.752 13.556C107.72 13.556 106.844 13.856 106.124 14.456C105.428 15.056 104.996 15.908 104.828 17.012H112.532ZM147.712 8.696C150.208 8.696 152.188 9.452 153.652 10.964C155.14 12.476 155.884 14.576 155.884 17.264V29H149.764V18.092C149.764 16.796 149.416 15.8 148.72 15.104C148.048 14.384 147.112 14.024 145.912 14.024C144.712 14.024 143.764 14.384 143.068 15.104C142.396 15.8 142.06 16.796 142.06 18.092V29H135.94V18.092C135.94 16.796 135.592 15.8 134.896 15.104C134.224 14.384 133.288 14.024 132.088 14.024C130.888 14.024 129.94 14.384 129.244 15.104C128.572 15.8 128.236 16.796 128.236 18.092V29H122.08V8.912H128.236V11.432C128.86 10.592 129.676 9.932 130.684 9.452C131.692 8.948 132.832 8.696 134.104 8.696C135.616 8.696 136.96 9.02 138.136 9.668C139.336 10.316 140.272 11.24 140.944 12.44C141.64 11.336 142.588 10.436 143.788 9.74C144.988 9.044 146.296 8.696 147.712 8.696ZM163.285 6.824C162.205 6.824 161.317 6.512 160.621 5.888C159.949 5.24 159.613 4.448 159.613 3.512C159.613 2.552 159.949 1.76 160.621 1.136C161.317 0.487998 162.205 0.163998 163.285 0.163998C164.341 0.163998 165.205 0.487998 165.877 1.136C166.573 1.76 166.921 2.552 166.921 3.512C166.921 4.448 166.573 5.24 165.877 5.888C165.205 6.512 164.341 6.824 163.285 6.824ZM166.345 8.912V29H160.189V8.912H166.345Z" fill="white"></path>
					</svg> -->
					<h4 class="fw-bold text-white">Kolkata Dealer</h4>
				</div> 
            </a>
            <div class="nav-control">
                <div class="hamburger">
                    <span class="line"></span><span class="line"></span><span class="line"></span>
					<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
						<rect x="22" y="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="11" y="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="11" y="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect y="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="22" y="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect y="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
					</svg>		
                </div>
            </div>
        </div>
        <!--/Nav header-->
		
		<!-- header -->
		<div class="header">
			<div class="header-content">
				<nav class="navbar navbar-expand">
					<div class="collapse navbar-collapse justify-content-between">
						<div class="header-left">
							<div class="dashboard_bar">Dashboard</div>
						</div>
						<?php include "header.php"; ?>
					</div>
				</nav>
			</div>
		</div>
		<!-- /header -->
		<?php include "sidebar.php"; ?>
		

        <!--Content body-->
		<div class="content-body">
			<div class="container-fluid">
				<!-- add school part -->
				<?php if ($perm_add_school) { ?>
				<div class="row">
					<div class="col-xl-12 col-lg-12">
						<?php 
						$stmt   = $pdo->query("SELECT * FROM listed_school ORDER BY id DESC");
						$schools = $stmt->fetchAll();
						if (count($schools) === 0): ?>
						<div class="card border-0 shadow-lg rounded-4 text-center p-5">
							<div class="card-body">
								<div class="mb-3 text-dark">
									<i class="bi bi-building"></i>
								</div>
								<p class="fs-5 text-muted mb-4">There are no schools listed right now.<br>Add your first school to get started.</p>
								<button id="openModalBtn" class="btn btn-primary px-4 py-2 rounded-pill shadow-sm" style="font-weight: 500;">
									<i class="bi bi-plus-lg me-2"></i>Add New School
								</button>
							</div>
						</div>
						<?php else: ?>
						<div class="card border-0 rounded-4 px-5 py-4">
							<div class="d-flex justify-content-between align-items-center mb-4">
								<h4 class="mb-0 text-dark fw-semibold"><i class="bi bi-building me-2"></i>Listed Schools</h4>
								<a id="openModalBtn" class="btn btn-sm btn-outline-primary px-3 py-2 rounded-pill fw-medium"><i class="bi bi-plus-lg me-2"></i>Add Another School</a>
							</div>
							<div class="table-responsive">
								<table class="table align-middle text-center table-hover mb-0">
									<thead class="small text-uppercase">
										<tr>
											<th class="fw-bold" scope="col" style="width: 45%;">School Name</th>
											<th class="fw-bold" scope="col">Action & Token</th>
										</tr>
									</thead>
									<tbody>
										<?php foreach ($schools as $row): 
										$isActive = strtolower((string)$row['is_active']);
										$checked  = ($isActive === 'active' || $isActive === '1' || $isActive === 'true') ? 'checked' : '';
										$rowClass = ($checked ? '' : 'table-secondary text-muted'); ?>
										<tr id="school-row-<?= (int)$row['id'] ?>" class="<?= $rowClass ?>">
											<td class="fw-bold text-primary"><a href="create_admin.php?id=<?= base64_encode($row['id'])?>"><?= htmlspecialchars($row['school']) ?></a></td>
											<td class="d-flex align-items-center justify-content-center gap-2">
												<span id="token-<?= $row['id'] ?>" class="text-muted fw-bold small"><?= htmlspecialchars($row['token']) ?></span>
												<a href="#" class="btn btn-sm btn-outline-secondary copy-btn px-2 py-1" data-target="#token-<?= $row['id'] ?>" title="Copy Token">
													<i class="bi bi-clipboard"></i>
												</a>
												<div class="form-check form-switch ms-2 mb-0">
													<input class="form-check-input listed-toggle" type="checkbox" role="switch" id="listedSwitch<?= $row['id'] ?>" data-id="<?= $row['id'] ?>" <?= $checked ?>>
													<label class="form-check-label small ms-1" for="listedSwitch<?= $row['id'] ?>"><?= $checked ? 'Active' : 'Inactive' ?></label>
												</div>
												<a href="create_admin.php?id=<?= base64_encode($row['id'])?>" class="btn btn-sm btn-outline-info rounded-circle text-center" title="Add Admins for this school">
													<i class="bi bi-eye"></i>
												</a>
											</td>
										</tr>
										<?php endforeach; ?>
									</tbody>
								</table>
							</div>
						</div>
						<?php endif; ?>
					</div>
				</div>
				<?php } ?>
				<!-- add mini superadmin part -->
				<?php if ($perm_create_mini) { ?>
				<div class="row">
					<div class="col-xl-12">
						<div class="card border-0 rounded-4 px-5 py-4">
							<div class="d-flex justify-content-between align-items-center mb-4">
								<h4 class="mb-0 text-dark fw-semibold"><i class="bi bi-people me-2"></i>Mini Superadmin Accounts</h4>
								<button id="openAddMiniBtn" type="button" class="btn btn-sm btn-outline-primary px-3 py-2"><i class="bi bi-plus-lg me-2"></i>Add Mini Superadmin</button>
							</div>
							<div class="table-responsive admin_table">
								<table id="miniTable" class="table align-middle text-center table-hover mb-0">
									<thead class="small text-uppercase">
										<tr>
											<th class="fw-bold text-center" scope="col">#</th>
											<th class="fw-bold text-center" scope="col">Email</th>
											<th class="fw-bold text-center" scope="col">Permissions</th>
											<th class="fw-bold text-center" scope="col">Action</th>
										</tr>
									</thead>
									<tbody id="miniTableBody"></tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
				<?php } ?>
				<!-- add school admins part -->
				<?php if ($perm_create_admin) { ?>
				<div class="row">
					<div class="col-xl-12">
						<div class="card border-0 rounded-4 px-5 py-4">
							<div class="mb-4">
								<h4 class="mb-0 text-dark fw-semibold"><i class="bi bi-people me-2"></i>Admin Accounts</h4>
							</div>
							<div class="table-responsive admin_table">
								<table id="adminTable" class="table align-middle text-center table-hover mb-0">
									<thead class="small text-uppercase">
										<tr>
											<th class="fw-bold text-center" scope="col" style="width: 10%;">#</th>
											<th class="fw-bold text-center" scope="col" style="width: 20%;">Name</th>
											<th class="fw-bold text-center" scope="col" style="width: 20%;">Email</th>
											<th class="fw-bold text-center" scope="col">Password</th>
											<th class="fw-bold text-center" scope="col">School</th>
											<th class="fw-bold text-center" scope="col">Action</th>
										</tr>
									</thead>
									<tbody>
										<?php 
										$stmt   = $pdo->query("SELECT * FROM admin ORDER BY id ASC");
										$admins = $stmt->fetchAll();
										$cnt = 1;
										foreach ($admins as $ad): ?>
										<tr data-admin-id="<?= $ad['id'] ?>" data-admin-name="<?= htmlspecialchars($ad['name']) ?>">
											<td class="fw-bold"><?= $cnt++; ?></td>
											<td class="fw-bold"><?= htmlspecialchars($ad['name']) ?></td>
											<td class="fw-bold"><?= htmlspecialchars($ad['email']) ?></td>
											<td class="fw-bold">
												<span class="password-display">****<?= substr($ad['password'], -4) ?></span>
												<input type="password" class="form-control form-control-sm d-none password-input" value="" placeholder="New password">
												<button class="btn btn-sm btn-outline-primary btn-edit ms-2 px-2 py-1" title="Edit Password"><i class="bi bi-pen"></i></button>
											</td>
											<td class="fw-bold"><?= htmlspecialchars($ad['school']) ?></td>
											<td class="d-flex align-items-center justify-content-center">
												<label class="form-check form-switch mb-0">
													<input class="form-check-input toggle-status" type="checkbox" data-id="<?= (int)$ad['id'] ?>" <?= $ad['status'] === 'Active' ? 'checked' : '' ?>>
													<span class="form-check-label"><?= $ad['status'] === 'Active' ? 'Active' : 'Inactive' ?></span>
												</label>
												<button class="btn btn-sm btn-outline-danger ms-2 btn-delete-admin" data-id="<?= (int)$ad['id'] ?>" data-name="<?= htmlspecialchars($ad['name'], ENT_QUOTES) ?>" title="Delete Admin"><i class="bi bi-trash"></i></button>
											</td>
										</tr>
										<?php endforeach; ?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
				<?php } ?>
			</div>
		</div>

		<!-- add school modal -->
		<div class="modal fade" id="schoolModal" tabindex="-1" aria-labelledby="schoolModalLabel" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content rounded-4 shadow-lg border-0">
					<div class="modal-header border-0">
						<h5 class="modal-title fw-semibold text-dark" id="schoolModalLabel"><i class="bi bi-plus-circle me-2 text-primary"></i>Add School</h5>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					<form id="schoolForm" novalidate>
						<div class="modal-body mt-2">
							<div class="mb-3">
								<label for="schoolName" class="form-label fw-medium text-secondary">School Name</label>
								<input type="text" class="form-control rounded-3 shadow-sm" id="schoolName" name="school" placeholder="Enter school name" required>
							</div>
							<div class="mb-3">
								<label for="schoolToken" class="form-label fw-medium text-secondary">Access Token</label>
								<div class="d-flex align-items-center" style="gap: 0.75rem;">
									<input type="text" class="form-control rounded-3 shadow-sm" id="schoolToken" name="token" readonly required style="flex: 1;">
									<button type="button" id="genTokenBtn" class="btn btn-outline-secondary px-3 py-2 rounded-pill d-flex align-items-center gap-1">
										<i class="bi bi-lightning-charge"></i><span>Generate</span>
									</button>
								</div>
							</div>
						</div>
						<div class="modal-footer border-0 pt-0">
							<button type="submit" class="btn btn-primary px-4 py-2 rounded-pill shadow-sm fw-semibold">
								<i class="bi bi-send-fill me-1"></i>Submit
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- /add school modal -->

		<!-- admin 
		=============================================================== -->

		<!-- confirm delete admin modal -->
		<div class="modal fade" id="confirmDeleteAdminModal" tabindex="-1" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Confirm delete</h5>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					<div class="modal-body">
						<p>Are you sure you want to delete this admin account? This action cannot be undone.</p>
						<p class="text-muted small">An OTP will be sent to the authorized email to confirm deletion.</p>
					</div>
					<div class="modal-footer">
						<button id="cancelDeleteAdminBtn" type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
						<button id="confirmSendAdminOtpBtn" type="button" class="btn btn-danger">Yes, send OTP</button>
					</div>
				</div>
			</div>
		</div>
		<!-- /confirm delete admin modal -->

		<!-- otp modal for admin -->
		<div class="modal fade" id="otpAdminModal" tabindex="-1" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content" style="border-radius:12px;overflow:hidden;">
					<div class="modal-body p-0">
						<div style="background:#fff;padding:1.2rem 1rem;">
							<div style="display:flex;align-items:center;gap:12px;">
								<div>
									<div style="font-weight:700;color:#222;font-size:1.05rem;">Kolkata Dealer</div>
									<div style="color:#666;font-size:0.9rem;">Confirm Deletion — Enter OTP</div>
								</div>
							</div>
							<div style="margin-top:16px;">
								<p style="margin:0 0 8px 0;color:#333;">We have sent a one-time password (OTP) to the authorized email. Enter it below to confirm deletion.</p>
								<div id="otpAdminInputWrap" style="display:flex;gap:8px;justify-content:center;margin-top:10px;">
									<input id="adminOtpInput" type="text" maxlength="6" inputmode="numeric" style="width:180px;padding:12px;border-radius:10px;border:1px solid #e6e6e6;text-align:center;font-size:1.05rem;letter-spacing:6px;" placeholder="• • • • • •">
								</div>
								<div style="display:flex;justify-content:space-between;align-items:center;margin-top:12px;">
									<small id="adminOtpTimer" style="color:#666">OTP expires in 05:00</small>
									<button id="resendAdminOtpBtn" class="btn btn-sm" style="background:#FB7D5B;color:#fff;border:none;border-radius:8px;padding:6px 10px;">Resend OTP</button>
								</div>
								<div style="margin-top:14px;display:flex;gap:8px;justify-content:flex-end;">
									<button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
									<button id="verifyAdminOtpBtn" type="button" class="btn" style="background:#4D44B5;color:#fff;border:none;">Verify & Delete</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /otp modal for admin -->

		<!-- ============================================================= 
		admin -->


		<!-- mini superadmin 
		=============================================================== -->

		<!-- add mini-superadmin modal -->
		<div class="modal fade" id="addMiniModal" tabindex="-1" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered">
				<form id="addMiniForm" class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Create Mini Superadmin</h5>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					<div class="modal-body">
						<div class="mb-3">
							<label class="form-label">Email</label>
							<input type="email" name="email" id="miniEmail" class="form-control" required>
						</div>
						<div class="mb-3">
							<label class="form-label">Password</label>
							<div class="input-group">
								<input type="text" name="password" id="miniPassword" class="form-control" required>
								<button type="button" class="btn btn-outline-secondary" id="genPassBtn">Generate</button>
							</div>
						</div>
						<div class="mb-3">
							<label class="form-label d-block">Assign Permissions</label>
							<div class="form-check form-switch">
								<input class="form-check-input" type="checkbox" id="permAddSchool">
								<label class="form-check-label" for="permAddSchool">Add Schools</label>
							</div>
							<div class="form-check form-switch">
								<input class="form-check-input" type="checkbox" id="permCreateAdmin">
								<label class="form-check-label" for="permCreateAdmin">Create Admin for School</label>
							</div>
							<div class="form-check form-switch">
								<input class="form-check-input" type="checkbox" id="permViewActivity">
								<label class="form-check-label" for="permViewActivity">View Activity</label>
							</div>
							<div class="form-check form-switch">
								<input class="form-check-input" type="checkbox" id="permCreateMini">
								<label class="form-check-label" for="permCreateMini">Create Mini Superadmin</label>
							</div>
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
						<button type="submit" class="btn btn-primary">Next: Preview</button>
					</div>
				</form>
			</div>
		</div>
		<!-- /add mini-superadmin modal -->

		<!-- preview modal for mini-superadmin -->
		<div class="modal fade" id="previewModal" tabindex="-1" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Confirm & Copy Mini Superadmin Credentials</h5>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					<div class="modal-body">
						<p>Please copy these credentials and then click <strong>Copy & Save</strong>. They will be saved to the system.</p>
						<pre id="previewText" style="white-space: pre-wrap; background:#f8f9fa; padding: 12px; border-radius:6px;"></pre>
					</div>
					<div class="modal-footer">
						<button id="previewCancel" type="button" class="btn btn-secondary" data-bs-dismiss="modal">Edit</button>
						<button id="copySaveBtn" type="button" class="btn btn-primary">Copy & Save</button>
					</div>
				</div>
			</div>
		</div>
		<!-- /preview modal for mini-superadmin -->

		<!-- edit modal for mini superadmin -->
		<div class="modal fade" id="editMiniPermModal" tabindex="-1" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered">
				<form id="editMiniPermForm" class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Edit Mini Superadmin Permissions</h5>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					<div class="modal-body">
						<input type="hidden" id="editMiniId" value="">
						<div class="mb-2">
							<div class="fw-semibold">Account</div>
							<div id="editMiniEmail" class="text-muted small"></div>
						</div>
						<div class="mb-3">
							<label class="form-label d-block">Permissions</label>
							<div class="form-check form-switch">
								<input class="form-check-input" type="checkbox" id="editPermAddSchool">
								<label class="form-check-label" for="editPermAddSchool">Add Schools</label>
							</div>
							<div class="form-check form-switch">
								<input class="form-check-input" type="checkbox" id="editPermCreateAdmin">
								<label class="form-check-label" for="editPermCreateAdmin">Create Admin for School</label>
							</div>
							<div class="form-check form-switch">
								<input class="form-check-input" type="checkbox" id="editPermViewActivity">
								<label class="form-check-label" for="editPermViewActivity">View Activity</label>
							</div>
							<div class="form-check form-switch">
								<input class="form-check-input" type="checkbox" id="editPermCreateMini">
								<label class="form-check-label" for="editPermCreateMini">Create Mini Superadmin</label>
							</div>
						</div>
						<div class="small text-muted">Toggle permissions and click Save. Changes are applied immediately.</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
						<button id="saveMiniPermBtn" type="submit" class="btn btn-primary">Save changes</button>
					</div>
				</form>
			</div>
		</div>
		<!-- /edit modal for mini superadmin -->

		<!-- confirm delete for mini superadmin -->
		<div class="modal fade" id="confirmDeleteModal" tabindex="-1" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Confirm delete</h5>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					<div class="modal-body">
						<p class="mb-0 fw-semibold">Are you sure you want to delete this mini-superadmin account? This action cannot be undone.</p>
						<p class="text-muted small">An OTP will be sent to the authorized email to confirm deletion.</p>
					</div>
					<div class="modal-footer border-0">
						<button id="cancelDeleteBtn" type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
						<button id="confirmSendOtpBtn" type="button" class="btn btn-danger">Yes, send OTP</button>
					</div>
				</div>
			</div>
		</div>
		<!-- /confirm delete for mini superadmin -->

		<!-- otp modal for mini superadmin -->
		<div class="modal fade" id="otpModal" tabindex="-1" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content" style="border-radius:12px;overflow:hidden;">
					<div class="modal-body p-0">
						<div style="background:#fff;padding:1.2rem 1rem;">
							<div style="display:flex;align-items:center;gap:12px;">
								<div>
									<div style="font-weight:700;color:#222;font-size:1.05rem;">Kolkata Dealer</div>
									<div style="color:#666;font-size:0.9rem;">Confirm Deletion — Enter OTP</div>
								</div>
							</div>
							<div style="margin-top:16px;">
								<p style="margin:0 0 8px 0;color:#333;">We have sent a one-time password (OTP) to the authorized email. Enter it below to confirm deletion.</p>
								<div id="otpInputWrap" style="display:flex;gap:8px;justify-content:center;margin-top:10px;">
									<input id="otpInput" type="text" maxlength="6" inputmode="numeric" style="width:180px;padding:12px;border-radius:10px;border:1px solid #e6e6e6;text-align:center;font-size:1.05rem;letter-spacing:6px;" placeholder="• • • • • •">
								</div>
								<div style="display:flex;justify-content:space-between;align-items:center;margin-top:12px;">
									<small id="otpTimer" style="color:#666">OTP expires in 05:00</small>
									<button id="resendOtpBtn" class="btn btn-sm" style="background:#FB7D5B;color:#fff;border:none;border-radius:8px;padding:6px 10px;">Resend OTP</button>
								</div>
								<div style="margin-top:14px;display:flex;gap:8px;justify-content:flex-end;">
									<button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
									<button id="verifyOtpBtn" type="button" class="btn" style="background:#4D44B5;color:#fff;border:none;">Verify & Delete</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /otp modal for mini superadmin -->

		<!-- ============================================================= 
		mini superadmin -->

		<?php include "footer.php" ?>

	</div>
    
<!-- All necessary scripts are here -->
<script>
	$(function() {
		var CURRENT_IS_MINI = <?= isset($isMini) ? (int)$isMini : 0 ?>;
		
		// data table initializations
		$('#adminTable').DataTable({
            pageLength: 30,
            lengthChange: false,
            ordering: false,
            info: false
        });
		$('#miniTable').DataTable({
            pageLength: 30,
            lengthChange: false,
            ordering: false,
            info: false
        });

		// school modal initialization
		var modal = new bootstrap.Modal(document.getElementById('schoolModal'));
		$('#openModalBtn').on('click', function() {
			$('#schoolForm')[0].reset();
			$('#schoolToken').val('');
			modal.show();
		});

		// Toast helper
		function Toast(text, isError = false){
			Toastify({
				text: text,
				duration: 3000,
				gravity: "top",
				position: "center",
				close: false,
				style: { background: isError ? "linear-gradient(90deg,#e63946,#b00020)" : "linear-gradient(90deg,#2ecc71,#27ae60)" }
			}).showToast();
		}

		// generate token btn on modal
		$('#genTokenBtn').on('click', function() {
			var chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
			var token = Array.from({ length: 6 }, () => chars.charAt(Math.floor(Math.random() * chars.length))).join('');
			$('#schoolToken').val(token);
		});

		// ajax for add school
		$('#schoolForm').on('submit', function(e) {
			e.preventDefault();
			var data = $(this).serialize() + '&action=add_school';
			$.post('add_school.php', data, function(res) {
			if (res.status === 'success') {
				modal.hide();
				Toastify({ text: res.message, duration: 3000, gravity: 'top', position: 'center', backgroundColor: 'green' }).showToast();
				setTimeout(() => location.reload(), 1000);
			} else {
				Toastify({ text: res.message, duration: 3000, gravity: 'top', position: 'center' }).showToast();
			}
			}, 'json').fail(function(xhr) {
				Toastify({ text: xhr.responseJSON?.message || 'Server error', duration: 3000, gravity: 'top', position: 'center', backgroundColor: 'red' }).showToast();
			});
		});

		// copy button for table
		$('.copy-btn').on('click', function() {
			var target = $($(this).data('target')).text();
			navigator.clipboard.writeText(target).then(function() {
				Toastify({ text: 'Copied to clipboard', duration: 2000, gravity: 'top', position: 'center' }).showToast();
			});
		});
	
		// update status for school ajax
		$(document).on('change', '.listed-toggle', function(){
			const $input = $(this);
			const schoolId = $input.data('id');
			const $label = $input.closest('td').find('label.form-check-label');
			const $row = $('#school-row-' + schoolId);
			$input.prop('disabled', true);
			$.post('toggle_school.php', { school_id: schoolId }, function(resp) {
				$input.prop('disabled', false);
				if (!resp || !resp.ok) {
					Toast(resp && resp.msg ? resp.msg : 'Failed to update status', true);
					$input.prop('checked', !$input.prop('checked'));
					$label.text($input.prop('checked') ? 'Active' : 'Inactive');
					if ($input.prop('checked')) { $row.removeClass('table-secondary text-muted'); }
					else { $row.addClass('table-secondary text-muted'); }
					return;
				}
				const status = resp.status === 'active' ? 'active' : 'inactive';
				const checked = status === 'active';
				$input.prop('checked', checked);
				$label.text(checked ? 'Active' : 'Inactive');
				if (checked) {
					$row.removeClass('table-secondary text-muted');
				} else {
					$row.addClass('table-secondary text-muted');
				}

				Toast(`School ${checked ? 'activated' : 'deactivated'}`);
			}, 'json').fail(function(){
				$input.prop('disabled', false);
				Toast('Network error - could not update', true);
				$input.prop('checked', !$input.prop('checked'));
				$label.text($input.prop('checked') ? 'Active' : 'Inactive');
				if ($input.prop('checked')) { $row.removeClass('table-secondary text-muted'); }
				else { $row.addClass('table-secondary text-muted'); }
			});
		});


		// admin ==================================================
		// admin table update password
		$('.admin_table').on('click', '.btn-edit', function(){
			const $td = $(this).closest('td');
			$td.addClass('d-flex align-items-center gap-1').find('.password-display').addClass('d-none');
			$td.find('.password-input').removeClass('d-none').addClass('flex-grow-1 me-2').focus();
			$(this).removeClass('btn-outline-warning btn-edit').addClass('btn-success btn-update').html('<i class="bi bi-check"></i>');
		});
		$('.admin_table').on('keydown', '.password-input', function(e){
			if (e.key === 'Enter') {
				e.preventDefault();
				$(this).closest('td').find('.btn-update').trigger('click');
			}
		});

		// update admin password ajax
		$('.admin_table').on('click', '.btn-update', function(){
			const $tr      = $(this).closest('tr');
			const adminId  = $tr.data('admin-id');
			const adminName= $tr.data('admin-name');
			const $input   = $tr.find('.password-input');
			const newPass  = $input.val().trim();
			if (!newPass) {
				Toastify({ text: 'Password cannot be empty', duration:3000, gravity:'top', position:'center', backgroundColor:'#ffc107' }).showToast();
				return;
			}
			$.ajax({
				url: 'update_admin_password.php',
				method: 'POST',
				data: { id: adminId, password: newPass },
				dataType: 'json',
				beforeSend() {
					Toastify({ text: 'Updating...', duration:600, gravity:'top', position:'center', backgroundColor:'#17a2b8' }).showToast();
				},
				success(res) {
					if (res.status === 'success') {
						Toastify({
							text: `Password updated for ${adminName}!`,
							duration:3000,
							gravity:'top',
							position:'center',
							backgroundColor:'#28a745'
						}).showToast();
						setTimeout(() => location.reload(), 1000);
					} else {
						Toastify({
							text: res.message,
							duration:3000,
							gravity:'top',
							position:'center',
							backgroundColor:'#dc3545'
						}).showToast();
					}
				},
				error() {
					Toastify({
						text: 'Server error',
						duration:3000,
						gravity:'top',
						position:'center',
						backgroundColor:'#dc3545'
					}).showToast();
				}
			});
		});

		// update status for admin ajax
		$(document).on('change', '.toggle-status', function(){
			const $chk = $(this);
			const adminId = $chk.data('id');
			const newStatus = $chk.is(':checked') ? 'Active' : 'Inactive';
			$.ajax({
				url: 'update_adminStatus.php',
				method: 'POST',
				dataType: 'json',
				data: {
					id: adminId,
					status: newStatus
				},
				success: function(res) {
					if(res.success) {
						$chk.next('label, .form-check-label').text(newStatus);
						Toastify({
							text: res.message,
							duration: 3000,
							gravity: "top",
							position: "center",
							backgroundColor: res.success ? "green" : "red"
						}).showToast();
					} else {
					$chk.prop('checked', ! $chk.is(':checked'));
						Toastify({
							text: res.message,
							duration: 3000,
							gravity: "top",
							position: "center",
							backgroundColor: "red"
						}).showToast();
					}
				},
				error: function(xhr, status, err) {
					$chk.prop('checked', ! $chk.is(':checked'));
					Toastify({
						text: "Server error. Try again.",
						duration: 3000,
						gravity: "top",
						position: "center",
						backgroundColor: "red"
					}).showToast();
				}
			});
		});

		// delete admin ----
		var selectedAdminDeleteId = null;
		var adminOtpTimerInterval = null;
		var adminOtpExpiresAt = null;
		// Helpers
		function admin_showToast(msg, type) {
			var bg = (type === 'success') ? 'linear-gradient(to right, #00b09b, #96c93d)' : (type === 'error') ? 'linear-gradient(to right,#ff416c,#ff4b2b)' : 'linear-gradient(to right,#4b6cb7,#182848)';
			Toastify({ text: msg, duration: 2000, gravity: "top", position: "center", style: { background: bg } }).showToast();
		}
		function showAdminModal(sel) { try { $(sel).modal('show'); } catch (e) { (new bootstrap.Modal(document.querySelector(sel))).show(); } }
		function hideAdminModal(sel) { try { $(sel).modal('hide'); } catch (e) { (new bootstrap.Modal(document.querySelector(sel))).hide(); } }
		function startAdminOtpTimer(seconds) {
			clearInterval(adminOtpTimerInterval);
			adminOtpExpiresAt = Date.now() + seconds*1000;
			updateAdminOtpTimerUI(seconds);
			adminOtpTimerInterval = setInterval(function () {
				var remaining = Math.ceil((adminOtpExpiresAt - Date.now())/1000);
				if (remaining <= 0) {
					clearInterval(adminOtpTimerInterval);
					$('#adminOtpTimer').text('OTP expired');
				} else {
					var mm = Math.floor(remaining/60);
					var ss = remaining % 60;
					$('#adminOtpTimer').text('OTP expires in ' + String(mm).padStart(2,'0') + ':' + String(ss).padStart(2,'0'));
				}
			}, 500);
		}
		// click handler for Delete button in admin table
		$(document).on('click', '.btn-delete-admin', function () {
			selectedAdminDeleteId = parseInt($(this).data('id'), 10) || null;
			var adminName = $(this).data('name') || '';
			if (!selectedAdminDeleteId) return;
			$('#confirmDeleteAdminModal .modal-body p:first').text('Are you sure you want to delete admin account "' + adminName + '"? This action cannot be undone.');
			showAdminModal('#confirmDeleteAdminModal');
		});
		// confirm -> send OTP
		$('#confirmSendAdminOtpBtn').on('click', function () {
			if (!selectedAdminDeleteId) { admin_showToast('Invalid id', 'error'); return; }
			$(this).prop('disabled', true).text('Sending...');
			$.ajax({
				url: 'send_otp_delete_admin.php',
				method: 'POST',
				dataType: 'json',
				data: { id: selectedAdminDeleteId },
				success: function (resp) {
					$('#confirmSendAdminOtpBtn').prop('disabled', false).text('Yes, send OTP');
					hideAdminModal('#confirmDeleteAdminModal');
					if (resp && resp.status === 'success') {
						admin_showToast(resp.message || 'OTP sent to authorized email', 'success');
						$('#adminOtpInput').val('');
						showAdminModal('#otpAdminModal');
						var secs = resp.expires_in ? parseInt(resp.expires_in,10) : 300;
						startAdminOtpTimer(secs);
					} else {admin_showToast((resp && resp.message) ? resp.message : 'Failed to send OTP', 'error');}
				},
				error: function () {
					$('#confirmSendAdminOtpBtn').prop('disabled', false).text('Yes, send OTP');
					admin_showToast('Server error while sending OTP', 'error');
				}
			});
		});
		// resend
		$('#resendAdminOtpBtn').on('click', function () {
			if (!selectedAdminDeleteId) { admin_showToast('Invalid id', 'error'); return; }
			var $btn = $(this).prop('disabled', true).text('Resending...');
			$.ajax({
				url: 'send_otp_delete_admin.php',
				method: 'POST',
				dataType: 'json',
				data: { id: selectedAdminDeleteId, resend: 1 },
				success: function (resp) {
					$btn.prop('disabled', false).text('Resend OTP');
					if (resp && resp.status === 'success') {
						admin_showToast(resp.message || 'OTP resent', 'success');
						var secs = resp.expires_in ? parseInt(resp.expires_in,10) : 300;
						startAdminOtpTimer(secs);
					} else {admin_showToast((resp && resp.message) ? resp.message : 'Failed to resend OTP', 'error');}
				},
				error: function () {
					$btn.prop('disabled', false).text('Resend OTP');
					admin_showToast('Server error while resending', 'error');
				}
			});
		});
		// verify and delete
		$('#verifyAdminOtpBtn').on('click', function () {
			var otp = $.trim($('#adminOtpInput').val());
			if (!otp || otp.length < 4) { admin_showToast('Enter the OTP', 'error'); return; }
			var $btn = $(this).prop('disabled', true).text('Verifying...');
			$.ajax({
				url: 'delete_admin.php',
				method: 'POST',
				dataType: 'json',
				data: { id: selectedAdminDeleteId, otp: otp },
				success: function (resp) {
					$btn.prop('disabled', false).text('Verify & Delete');
					if (resp && resp.status === 'success') {
						admin_showToast(resp.message || 'Deleted', 'success');
						hideAdminModal('#otpAdminModal');
						setTimeout(function () { location.reload(); }, 800);
					} else {admin_showToast((resp && resp.message) ? resp.message : 'Invalid OTP', 'error');}
				},
				error: function () {
					$btn.prop('disabled', false).text('Verify & Delete');
					admin_showToast('Server error while verifying OTP', 'error');
				}
			});
		});
		$('#otpAdminModal').on('hidden.bs.modal', function () {
			clearInterval(adminOtpTimerInterval); adminOtpTimerInterval = null;
		});

		// mini superadmin ========================================
		// ----helpers----
		function showToast(message, type) {
			var bg;
			if (type === 'success') bg = 'linear-gradient(to right, #00b09b, #96c93d)';
			else if (type === 'error') bg = 'linear-gradient(to right,#ff416c,#ff4b2b)';
			else bg = 'linear-gradient(to right,#4b6cb7,#182848)';
			Toastify({
				text: message,
				duration: 1500,
				gravity: "top",
				position: "center",
				style: { background: bg }
			}).showToast();
		}
		function escapeHtml(str) {
			return String(str)
			.replace(/&/g, '&amp;')
			.replace(/</g, '&lt;')
			.replace(/>/g, '&gt;')
			.replace(/"/g, '&quot;')
			.replace(/'/g, '&#39;');
		}
		function generatePassword(len) {
			len = len || 12;
			var charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()_+[]{}";
			var ret = "";
			for (var i = 0; i < len; i++) {ret += charset.charAt(Math.floor(Math.random() * charset.length));}
			return ret;
		}
		function showModal(selector) {
			try { $(selector).modal('show'); } catch (e) { 
				try { (new bootstrap.Modal(document.querySelector(selector))).show(); } catch (ee) {}
			}
		}
		function hideModal(selector) {
			try { $(selector).modal('hide'); } catch (e) {
				try { (new bootstrap.Modal(document.querySelector(selector))).hide(); } catch (ee) {}
			}
		}

		// open add modal ----------
		$('#openAddMiniBtn').on('click', function () {
			$('#addMiniForm')[0].reset();
			$('#previewText').text('');
			showModal('#addMiniModal');
		});
		// generate password ----------
		$('#genPassBtn').on('click', function (e) {
			e.preventDefault();
			var pwd = generatePassword(12);
			$('#miniPassword').val(pwd);
		});
		// submit form -> preview ----------
		$('#addMiniForm').on('submit', function (e) {
			e.preventDefault();
			var email = $.trim($('#miniEmail').val());
			var password = $('#miniPassword').val();
			if (!email || !password) {
				showToast('Email and password are required', 'error');
				return;
			}
			var re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
			if (!re.test(email)) {
				showToast('Enter a valid email', 'error');
				return;
			}
			var preview = 'id - ' + email + ', password - ' + password;
			$('#previewText').text(preview);
			hideModal('#addMiniModal');
			showModal('#previewModal');
		});
		// Copy & Save action ----------
		$('#copySaveBtn').on('click', function () {
			var email = $.trim($('#miniEmail').val());
			var password = $('#miniPassword').val();
			var copyText = 'id - ' + email + ', password - ' + password;
			function doSaveAfterCopy() {
				var fd = new FormData();
				fd.append('email', email);
				fd.append('password', password);
				fd.append('permission_add_school', $('#permAddSchool').is(':checked') ? 1 : 0);
				fd.append('permission_create_admin', $('#permCreateAdmin').is(':checked') ? 1 : 0);
				fd.append('permission_view_activity', $('#permViewActivity').is(':checked') ? 1 : 0);
				fd.append('permission_create_mini', $('#permCreateMini').is(':checked') ? 1 : 0);
				$.ajax({
					url: 'add_mini_superadmin.php',
					method: 'POST',
					data: fd,
					processData: false,
					contentType: false,
					success: function (resp) {
						if (typeof resp === 'string') {
							try { resp = JSON.parse(resp); } catch (e) {}
						}
						if (resp && resp.status === 'success') {
							showToast(resp.message || 'Mini superadmin created', 'success');
							hideModal('#previewModal');
							setTimeout(function () { location.reload(); }, 1500);
						} else {
							showToast((resp && resp.message) ? resp.message : 'Server error', 'error');
						}
					},
					error: function () {
						showToast('Server error', 'error');
					}
				});
			}
			// Use Clipboard API when available
			if (navigator.clipboard && navigator.clipboard.writeText) {
				navigator.clipboard.writeText(copyText).then(function () {
					doSaveAfterCopy();
				}).catch(function () {
					fallbackCopyAndSave(copyText, doSaveAfterCopy);
				});
			} else {fallbackCopyAndSave(copyText, doSaveAfterCopy);}
		});
		// fall back copy function
		function fallbackCopyAndSave(text, callback) {
			var $temp = $('<textarea>');
			$('body').append($temp);
			$temp.val(text).select();
			try {
				var ok = document.execCommand('copy');
				$temp.remove();
				if (ok) callback();
				else showToast('Failed to copy to clipboard', 'error');
			} catch (e) {
				$temp.remove();
				showToast('Copy to clipboard not supported', 'error');
			}
		}
		// fetch and render mini superadmins table ----------
		function loadMiniAdmins() {
			$.getJSON('fetch_mini_superadmins.php').done(function (resp) {
				if (!resp || resp.status !== 'success') { return; }
				var rows = resp.data || [];
				var $tbody = $('#miniTableBody');
				$tbody.empty();
				if (rows.length === 0) {
					$tbody.append('<tr><td colspan="4"><em>No mini superadmins yet</em></td></tr>');
					return;
				}
				$.each(rows, function (i, r) {
					var permsArr = [];
					if (r.permission_add_school) permsArr.push('Add School');
					if (r.permission_create_admin) permsArr.push('Create Admin');
					if (r.permission_view_activity) permsArr.push('View Activity');
					if (r.permission_create_mini) permsArr.push('Create Mini');
					var permsHtml = permsArr.length ? escapeHtml(permsArr.join(', ')) : '<em>None</em>';
					var $tr = $('<tr>').attr('data-id', r.id).attr('data-email', r.email)
					.attr('data-perm-add-school', r.permission_add_school ? 1 : 0).attr('data-perm-create-admin', r.permission_create_admin ? 1 : 0)
					.attr('data-perm-view-activity', r.permission_view_activity ? 1 : 0).attr('data-perm-create-mini', r.permission_create_mini ? 1 : 0);

					$tr.append($('<td class="fw-bold">').text(i + 1));
					$tr.append($('<td class="fw-bold">').html(escapeHtml(r.email)));
					$tr.append($('<td class="fw-bold perms-col">').html(permsHtml));

					var $actionsTd = $('<td>');
					if (typeof CURRENT_IS_MINI === 'undefined' || CURRENT_IS_MINI === 0) {
						var $editBtn = $('<button>').addClass('btn btn-sm btn-outline-primary btn-edit-mini me-2').attr('title', 'Edit Permissions').attr('data-id', r.id).attr('data-email', r.email).html('<i class="bi bi-pencil"></i>');
						$actionsTd.append($editBtn);
					}
					var $delBtn = $('<button>').addClass('btn btn-sm btn-outline-danger').html('<i class="bi bi-trash"></i>').attr('data-id', r.id).on('click', function () { deleteMini(r.id); });
					$actionsTd.append($delBtn);

					$tr.append($actionsTd);
					$tbody.append($tr);
				});
			}).fail(function () {showToast('Failed to load mini admins', 'error');});
		}
		loadMiniAdmins();

		// edit mini ------------
		$(document).on('click', '.btn-edit-mini', function () {
			var $btn = $(this);
			var id = $btn.data('id');
			var email = $btn.data('email');
			var $row = $('tr[data-id="' + id + '"]');
			if ($row.length === 0) {
				showToast('Row not found', 'error');
				return;
			}
			$('#editMiniId').val(id);
			$('#editMiniEmail').text(email);
			$('#editPermAddSchool').prop('checked', $row.attr('data-perm-add-school') === '1');
			$('#editPermCreateAdmin').prop('checked', $row.attr('data-perm-create-admin') === '1');
			$('#editPermViewActivity').prop('checked', $row.attr('data-perm-view-activity') === '1');
			$('#editPermCreateMini').prop('checked', $row.attr('data-perm-create-mini') === '1');
			try { $('#editMiniPermModal').modal('show'); } catch (e) { (new bootstrap.Modal(document.getElementById('editMiniPermModal'))).show(); }
		});
		// save permission changes via AJAX (no reload)
		$('#editMiniPermForm').on('submit', function (e) {
			e.preventDefault();
			var id = parseInt($('#editMiniId').val(), 10);
			if (!id) { showToast('Invalid id', 'error'); return; }
			var payload = {
			id: id,
				permission_add_school: $('#editPermAddSchool').is(':checked') ? 1 : 0,
				permission_create_admin: $('#editPermCreateAdmin').is(':checked') ? 1 : 0,
				permission_view_activity: $('#editPermViewActivity').is(':checked') ? 1 : 0,
				permission_create_mini: $('#editPermCreateMini').is(':checked') ? 1 : 0
			};
			$('#saveMiniPermBtn').prop('disabled', true).text('Saving...');
			$.ajax({
				url: 'update_mini_permissions.php',
				method: 'POST',
				dataType: 'json',
				data: payload,
				success: function (resp) {
					$('#saveMiniPermBtn').prop('disabled', false).text('Save changes');
					if (resp && resp.status === 'success') {
						var $row = $('tr[data-id="' + id + '"]');
						if ($row.length) {
							$row.attr('data-perm-add-school', payload.permission_add_school);
							$row.attr('data-perm-create-admin', payload.permission_create_admin);
							$row.attr('data-perm-view-activity', payload.permission_view_activity);
							$row.attr('data-perm-create-mini', payload.permission_create_mini);
							var perms = [];
							if (payload.permission_add_school) perms.push('Add School');
							if (payload.permission_create_admin) perms.push('Create Admin');
							if (payload.permission_view_activity) perms.push('View Activity');
							if (payload.permission_create_mini) perms.push('Create Mini');
							var permsHtml = perms.length ? escapeHtml(perms.join(', ')) : '<em>None</em>';
							$row.find('.perms-col').html(permsHtml);
						}
						showToast(resp.message || 'Permissions updated', 'success');
						try { $('#editMiniPermModal').modal('hide'); } catch (e) { (new bootstrap.Modal(document.getElementById('editMiniPermModal'))).hide(); }
					} else {showToast((resp && resp.message) ? resp.message : 'Failed to update permissions', 'error');}
				},
				error: function () {
					$('#saveMiniPermBtn').prop('disabled', false).text('Save changes');
					showToast('Server error while saving', 'error');
				}
			});
		});

		// delete mini ----------
		var selectedDeleteId = null;
		var otpExpiresAt = null;
		var otpTimerInterval = null;
		function showModal(sel) { try { $(sel).modal('show'); } catch (e) { (new bootstrap.Modal(document.querySelector(sel))).show(); } }
		function hideModal(sel) { try { $(sel).modal('hide'); } catch (e) { (new bootstrap.Modal(document.querySelector(sel))).hide(); } }

		// start OTP timer UI
		function startOtpTimer(seconds) {
			clearInterval(otpTimerInterval);
			var remaining = seconds;
			otpExpiresAt = Date.now() + seconds * 1000;
			updateOtpTimerUI(remaining);
			otpTimerInterval = setInterval(function () {
				remaining = Math.ceil((otpExpiresAt - Date.now())/1000);
				if (remaining <= 0) {
					clearInterval(otpTimerInterval);
					$('#otpTimer').text('OTP expired');
				} else {
					updateOtpTimerUI(remaining);
				}
			}, 500);
		}
		function updateOtpTimerUI(seconds) {
			var mm = Math.floor(seconds / 60);
			var ss = seconds % 60;
			$('#otpTimer').text('OTP expires in ' + String(mm).padStart(2,'0') + ':' + String(ss).padStart(2,'0'));
		}
		// override deleteMini to open confirmation modal
		window.deleteMini = function (id) {
			selectedDeleteId = parseInt(id, 10) || null;
			if (!selectedDeleteId) return;
			showModal('#confirmDeleteModal');
		};
		// when confirm -> call server to send OTP
		$('#confirmSendOtpBtn').on('click', function () {
			if (!selectedDeleteId) {showToast('Invalid id', 'error'); return;}
			$(this).prop('disabled', true).text('Sending...');
			$.ajax({
				url: 'send_otp_delete.php',
				method: 'POST',
				dataType: 'json',
				data: { id: selectedDeleteId },
				success: function (resp) {
					$('#confirmSendOtpBtn').prop('disabled', false).text('Yes, send OTP');
					hideModal('#confirmDeleteModal');
					if (resp && resp.status === 'success') {
						showToast(resp.message || 'OTP sent to authorized email', 'success');
						$('#otpInput').val('');
						showModal('#otpModal');
						var secs = (resp.expires_in && parseInt(resp.expires_in,10)) ? parseInt(resp.expires_in,10) : 300;
						startOtpTimer(secs);
					} else {showToast((resp && resp.message) ? resp.message : 'Failed to send OTP', 'error');}
				},
				error: function () {
					$('#confirmSendOtpBtn').prop('disabled', false).text('Yes, send OTP');
					showToast('Server error while sending OTP', 'error');
				}
			});
		});
		// resend OTP
		$('#resendOtpBtn').on('click', function () {
			if (!selectedDeleteId) { showToast('Invalid id', 'error'); return; }
			$(this).prop('disabled', true).text('Resending...');
			$.ajax({
				url: 'send_otp_delete.php',
				method: 'POST',
				dataType: 'json',
				data: { id: selectedDeleteId, resend: 1 },
				success: function (resp) {
					$('#resendOtpBtn').prop('disabled', false).text('Resend OTP');
					if (resp && resp.status === 'success') {
						showToast(resp.message || 'OTP resent', 'success');
						var secs = (resp.expires_in && parseInt(resp.expires_in,10)) ? parseInt(resp.expires_in,10) : 300;
						startOtpTimer(secs);
					} else {showToast((resp && resp.message) ? resp.message : 'Failed to resend OTP', 'error');}
				},
				error: function () {
					$('#resendOtpBtn').prop('disabled', false).text('Resend OTP');
					showToast('Server error while resending', 'error');
				}
			});
		});
		// verify OTP and delete
		$('#verifyOtpBtn').on('click', function () {
			var otp = $.trim($('#otpInput').val());
			if (!otp || otp.length < 4) {showToast('Enter the OTP', 'error'); return;}
			$(this).prop('disabled', true).text('Verifying...');
			$.ajax({
				url: 'delete_mini_superadmin.php',
				method: 'POST',
				dataType: 'json',
				data: { id: selectedDeleteId, otp: otp },
				success: function (resp) {
					$('#verifyOtpBtn').prop('disabled', false).text('Verify & Delete');
					if (resp && resp.status === 'success') {
						showToast(resp.message || 'Deleted', 'success');
						hideModal('#otpModal');
						setTimeout(function () { location.reload(); }, 800);
					} else {showToast((resp && resp.message) ? resp.message : 'Invalid OTP', 'error');}
				},
				error: function () {
					$('#verifyOtpBtn').prop('disabled', false).text('Verify & Delete');
					showToast('Server error while verifying OTP', 'error');
				}
			});
		});
		$('#otpModal').on('hidden.bs.modal', function () {
			clearInterval(otpTimerInterval);
			otpTimerInterval = null;
		});
		$('#previewCancel').on('click', function () {
			hideModal('#previewModal');
			showModal('#addMiniModal');
		});
	});
</script>
<?php include "footerlink.php"; ?>