<?php
session_start();
require_once 'config.php';
header('Content-Type: application/json');

if (empty($_SESSION['id'])) {
    echo json_encode(['status'=>'error','message'=>'Unauthorized']); exit;
}
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status'=>'error','message'=>'Invalid request']); exit;
}
$inputId = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$inputOtp = isset($_POST['otp']) ? trim($_POST['otp']) : '';

if (!$inputId || $inputOtp === '') {
    echo json_encode(['status'=>'error','message'=>'Invalid input']); exit;
}
if (!isset($_SESSION['delete_admin_otp']) || !is_array($_SESSION['delete_admin_otp'])) {
    echo json_encode(['status'=>'error','message'=>'No OTP session found']); exit;
}

$record = $_SESSION['delete_admin_otp'];
$now = time();

if (!isset($record['expires_at']) || $now > (int)$record['expires_at']) {
    unset($_SESSION['delete_admin_otp']);
    echo json_encode(['status'=>'error','message'=>'OTP expired']); exit;
}
if (!isset($record['id']) || (int)$record['id'] !== $inputId) {
    echo json_encode(['status'=>'error','message'=>'OTP does not match requested action']); exit;
}
if (!isset($record['otp']) || $record['otp'] !== $inputOtp) {
    echo json_encode(['status'=>'error','message'=>'Invalid OTP']); exit;
}

try {
    $stmt = $pdo->prepare("DELETE FROM admin WHERE id = ?");
    $stmt->execute([$inputId]);

    unset($_SESSION['delete_admin_otp']);
    echo json_encode(['status'=>'success','message'=>'Admin deleted']);
} catch (PDOException $e) {
    echo json_encode(['status'=>'error','message'=>'Server error while deleting']);
} ?>