<?php
session_start();
header('Content-Type: application/json; charset=utf-8');
include 'config.php';
function json($ok,$msg){ echo json_encode(['status'=>$ok,'message'=>$msg]); exit; }

if ($_SERVER['REQUEST_METHOD'] !== 'POST') json(false,'Invalid request');

if (empty($_SESSION['pwd_reset']) || empty($_SESSION['pwd_reset_verified']) || $_SESSION['pwd_reset_verified'] !== true) {
    json(false, 'OTP verification required.');
}

$new = $_POST['new_password'] ?? '';
$confirm = $_POST['confirm_password'] ?? '';
if (!$new || !$confirm) json(false, 'Fill both fields');
if ($new !== $confirm) json(false, 'Passwords do not match');

$teacherId = (int)($_SESSION['pwd_reset']['teacher_id'] ?? 0);
if (!$teacherId) json(false, 'Invalid session data');

try {
    $hash = password_hash($new, PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("UPDATE superadmin SET password = :pw WHERE id = :id LIMIT 1");
    $stmt->execute([':pw'=>$hash, ':id'=>$teacherId]);

    unset($_SESSION['pwd_reset']);
    unset($_SESSION['pwd_reset_verified']);

    json(true, 'Password updated successfully');
} catch (PDOException $e) {
    json(false, 'Server error: '.$e->getMessage());
} ?>