<?php
session_start();
header('Content-Type: application/json; charset=utf-8');
function json($ok,$msg){ echo json_encode(['status'=>$ok,'message'=>$msg]); exit; }
if ($_SERVER['REQUEST_METHOD'] !== 'POST') json(false,'Invalid request');

$entered = trim($_POST['otp'] ?? '');
if ($entered === '') json(false,'Enter the OTP');

if (empty($_SESSION['pwd_reset'])) json(false,'No OTP session found. Please request OTP again.');

$rec = $_SESSION['pwd_reset'];
if (time() > ($rec['expires'] ?? 0)) {
    unset($_SESSION['pwd_reset']);
    json(false,'OTP expired. Please request a new one.');
}

if (!hash_equals((string)$rec['otp'], (string)$entered)) {
    json(false,'Invalid OTP');
}

$_SESSION['pwd_reset_verified'] = true;
json(true,'OTP verified'); ?>