<?php
session_start();
require_once 'config.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status'=>'error','message'=>'Invalid request']);
    exit;
}
$name = trim($_POST['name'] ?? '');
$email = trim($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';

if (empty($name) || empty($email) || empty($password)) {
    echo json_encode(['status'=>'error','message'=>'All fields are required']);
    exit;
}
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['status'=>'error','message'=>'Invalid email address']);
    exit;
}

try {
    $stmt = $pdo->prepare("SELECT id FROM superadmin WHERE email = ?");
    $stmt->execute([$email]);
    if ($stmt->rowCount() > 0) {
        echo json_encode(['status'=>'error','message'=>'Email already registered']);
        exit;
    }
    $hashedPassword = password_hash($password, PASSWORD_BCRYPT);

    $stmt = $pdo->prepare("INSERT INTO superadmin (name, email, password, is_mini_superadmin, permission_add_school, permission_create_admin, permission_view_activity, permission_create_mini) VALUES (?, ?, ?, 0, 1, 1, 1, 1)");
    $stmt->execute([$name, $email, $hashedPassword]);

    echo json_encode(['status'=>'success','message'=>'Registration successful! Redirecting to Login...']);
} catch (Exception $e) {
    echo json_encode(['status'=>'error','message'=>'Server error: '.$e->getMessage()]);
} ?>