<?php 
session_start();
include "headerlink_II.php"; ?>

<body class="body  h-100">
	<div class="authincation d-flex flex-column flex-lg-row flex-column-fluid">
		<div class="login-aside text-center  d-flex flex-column flex-row-auto">
			<div class="d-flex flex-column-auto flex-column pt-lg-40 pt-15">
				<div class="text-center mb-lg-4 mb-2 pt-5 logo">
					<!-- <img src="images/logo-white.png" alt=""> -->
					<h1 class="fw-bold text-white">Kolkata Dealer</h1>
				</div>
				<h3 class="mb-2 text-white">Welcome back!</h3>
				<p class="mb-4">One Dashboard for managing </br> your schools</p>
			</div>
			<div class="aside-image position-relative" style="background-image:url(images/pic-2.png);"></div>
		</div>
		<div class="container flex-row-fluid d-flex flex-column justify-content-center position-relative overflow-hidden p-7 mx-auto">
			<div class="d-flex justify-content-center h-100 align-items-center">
				<div class="authincation-content style-2">
					<div class="row no-gutters">
						<div class="col-xl-12 tab-content">
							<div id="sign-up" class="auth-form tab-pane fade show active form-validation">
								<form id="loginForm">
									<div class="text-center mb-4">
										<h3 class="text-center mb-2 text-black">Sign In</h3>
										<span><strong>Superadmin</strong> Sign In</span>
									</div>
									<div class="mb-3">
										<label for="email" class="form-label mb-2 fs-13 label-color font-w500">Email address</label>
									  	<input type="email" class="form-control" id="email" name="email" placeholder="hello@example.com">
									</div>
									<div class="mb-3">
										<label for="password" class="form-label mb-2 fs-13 label-color font-w500">Password</label>
									  	<input type="password" class="form-control" id="password" name="password" placeholder="****">
									</div>
									<!-- <a href="javascript:void(0);" class="text-primary float-end mb-4">Forgot Password ?</a> -->
									<button type="submit" class="btn btn-block btn-primary">Sign In</button>
								</form>
								<div class="new-account mt-3 text-center">
									<p class="font-w500">Don't have an account? <a class="text-primary" href="signup.php">Sign Up</a></p>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

<!-- All necessary scripts are here -->
<script>
	$(document).ready(function () {
		// login ajax
		$('#loginForm').on('submit', function (e) {
			e.preventDefault();
			const email = $('#email').val().trim();
			const password = $('#password').val().trim();
			if (!email || !password) {
				Toastify({
					text: "Please fill all fields!",
					duration: 2000,
					gravity: "top",
					position: "center",
					backgroundColor: "linear-gradient(to right, #ff416c, #ff4b2b)"
				}).showToast();
				return;
			}
			Toastify({
				text: "Checking credentials...",
				duration: 800,
				gravity: "top",
				position: "center",
				backgroundColor: "#007bff"
			}).showToast();
			$.ajax({
				url: 'process_signin.php',
				type: 'POST',
				data: { email, password },
				dataType: 'json',
				success: function (res) {
					Toastify({
						text: res.message,
						duration: 1000,
						gravity: "top",
						position: "center",
						backgroundColor: res.status === 'success' ? "green" : "red"
					}).showToast();
					if (res.status === 'success') {
						setTimeout(() => {
							window.location.href = "dashboard.php";
						}, 1000);
					}
				},
				error: function () {
					Toastify({
						text: "Something went wrong on server",
						duration: 2000,
						gravity: "top",
						position: "center",
						backgroundColor: "red"
					}).showToast();
				}
			});
		});

		// check mail type
		var $email = $('#email');
		var $newAccount = $('.new-account');
		var debounceTimer = null;
		var lastXhr = null;
		var DEBOUNCE_DELAY = 350;
		$newAccount.show();

		$email.on('input', function () {
			var val = $.trim($email.val());
			if (!val || val.indexOf('@') === -1) {
				if (lastXhr && lastXhr.readyState !== 4) lastXhr.abort();
				$newAccount.show();
				return;
			}
			clearTimeout(debounceTimer);
			debounceTimer = setTimeout(function () {
				if (lastXhr && lastXhr.readyState !== 4) lastXhr.abort();
				lastXhr = $.ajax({
					url: 'check_email_type.php',
					method: 'GET',
					data: { email: val },
					dataType: 'json',
					success: function (res) {
						if (res && res.status === 'success') {
							if (parseInt(res.is_mini, 10) === 1) {$newAccount.hide();} 
							else {$newAccount.show();}
						} else {$newAccount.show();}
					},
					error: function () {$newAccount.show();}
				});
			}, DEBOUNCE_DELAY);
		}); 
	});
</script>

<?php include "footerlink.php"; ?>