<?php 
session_start();
include "headerlink_II.php"; ?>

<body class="body  h-100">
	<div class="authincation d-flex flex-column flex-lg-row flex-column-fluid">
		<div class="login-aside text-center  d-flex flex-column flex-row-auto">
			<div class="d-flex flex-column-auto flex-column pt-lg-40 pt-15">
				<div class="text-center mb-lg-4 mb-2 pt-5 logo">
					<!-- <img src="images/logo-white.png" alt=""> -->
					<h1 class="fw-bold text-white">Kolkata Dealer</h1>
				</div>
				<h3 class="mb-2 text-white">Create Account!</h3>
				<p class="mb-4">One Dashboard for managing </br> your schools</p>
			</div>
			<div class="aside-image position-relative" style="background-image:url(images/pic-2.png);"></div>
		</div>
		<div class="container flex-row-fluid d-flex flex-column justify-content-center position-relative overflow-hidden p-7 mx-auto">
			<div class="d-flex justify-content-center h-100 align-items-center">
				<div class="authincation-content style-2">
					<div class="row no-gutters">
						<div class="col-xl-12 tab-content">
							<div id="sign-up" class="auth-form tab-pane fade show active  form-validation">
								<form id="registerForm">
									<div class="text-center mb-4">
										<h3 class="text-center mb-2 text-black">Sign Up</h3>
										<span><strong>Superadmin</strong> Sign Up</span>
									</div>
                                    <div class="mb-3">
										<label for="name" class="form-label mb-2 fs-13 label-color font-w500">Full Name</label>
									  	<input type="text" class="form-control" id="name" name="name" placeholder="Your Name">
									</div>
									<div class="mb-3">
										<label for="email" class="form-label mb-2 fs-13 label-color font-w500">Email address</label>
									  	<input type="email" class="form-control" id="email" name="email" placeholder="Your Email id">
									</div>
									<div class="mb-3">
										<label for="password" class="form-label mb-2 fs-13 label-color font-w500">Password</label>
									  	<input type="password" class="form-control" id="password" name="password" placeholder="Create a Password">
                                        <div id="passwordFeedback" class="form-text mt-1 d-flex align-items-center gap-1">
                                            <i class="bi bi-shield-lock me-2 text-muted" id="feedbackIcon"></i>
                                            <span id="passwordMessage" class="text-muted">Password must contain 8 characters, 1 uppercase, 1 lowercase, 1 number, 1 special character.</span>
                                        </div>
									</div>
									<button type="submit" class="btn btn-block btn-primary">Sign Up</button>
								</form>
								<div class="new-account mt-3 text-center">
									<p class="font-w500">Already have an account? <a class="text-primary" href="signin.php">Sign In</a></p>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

<!-- All necessary scripts are here -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const passwordInput = document.getElementById("password");
        const feedbackMsg = document.getElementById("passwordMessage");
        const feedbackIcon = document.getElementById("feedbackIcon");
        const registerForm = document.getElementById("registerForm");

        // password validation
        let isPasswordValid = false;
        function validatePassword(password) {
            const lengthCheck = password.length >= 8;
            const upperCheck = /[A-Z]/.test(password);
            const lowerCheck = /[a-z]/.test(password);
            const numberCheck = /[0-9]/.test(password);
            const specialCheck = /[!@#$%^&*(),.?":{}|<>]/.test(password);

            isPasswordValid = lengthCheck && upperCheck && lowerCheck && numberCheck && specialCheck;

            if (isPasswordValid) {
                feedbackMsg.textContent = "Password is strong";
                feedbackMsg.className = "text-success";
                feedbackIcon.className = "bi bi-shield-check me-2 text-success";
            } else {
                const issues = [];
                if (!lengthCheck) issues.push("8 characters");
                if (!upperCheck) issues.push("1 uppercase");
                if (!lowerCheck) issues.push("1 lowercase");
                if (!numberCheck) issues.push("1 number");
                if (!specialCheck) issues.push("1 special char");

                feedbackMsg.textContent = "Missing: " + issues.join(', ');
                feedbackMsg.className = "text-danger";
                feedbackIcon.className = "bi bi-shield-lock text-danger";
            }
            return { lengthCheck, upperCheck, lowerCheck, numberCheck, specialCheck };
        }
        passwordInput.addEventListener("input", function () {
            const pwd = passwordInput.value;
            validatePassword(pwd);
        });

        // register ajax
        registerForm.addEventListener("submit", function (e) {
            e.preventDefault();
            const name = document.getElementById("name").value.trim();
            const email = document.getElementById("email").value.trim();
            const password = passwordInput.value.trim();
            const checks = validatePassword(password);

            if (!isPasswordValid) {
                if (!checks.lengthCheck) {
                    showToast("Password must be at least 8 characters long!");
                } else if (!checks.upperCheck) {
                    showToast("Password must have at least 1 uppercase letter!");
                } else if (!checks.lowerCheck) {
                    showToast("Password must have at least 1 lowercase letter!");
                } else if (!checks.numberCheck) {
                    showToast("Password must have at least 1 number!");
                } else if (!checks.specialCheck) {
                    showToast("Password must have at least 1 special character!");
                }
                return;
            }
            showToast("Registering...", "#007bff");

            const formData = new FormData();
            formData.append("name", name);
            formData.append("email", email);
            formData.append("password", password);
            fetch("process_signup.php", {
                method: "POST",
                body: formData
            })
            .then(res => res.json())
            .then(response => {
                showToast(response.message, response.status === 'success' ? "green" : "red");
                if (response.status === "success") {
                    setTimeout(() => window.location.href = "signin.php", 1000);
                }
            })
            .catch(() => {
                showToast("Something went wrong", "red");
            });
        });

        // toastify helper
        function showToast(msg, color = "linear-gradient(to right, #ff5f6d, #ffc371)") {
            Toastify({
                text: msg,
                duration: 2000,
                gravity: "top",
                position: "center",
                backgroundColor: color
            }).showToast();
        }
    });
</script>

<?php include "footerlink.php"; ?>