<?php
header('Content-Type: application/json');
require_once 'config.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);
    $status = filter_input(INPUT_POST, 'status', FILTER_SANITIZE_STRING);

    if (!$id || !in_array($status, ['Active','Inactive'], true)) {
        throw new Exception('Invalid data');
    }

    $stmt = $pdo->prepare("UPDATE admin SET status = :status WHERE id = :id");
    $stmt->execute([
        ':status' => $status,
        ':id'     => $id
    ]);
    if ($stmt->rowCount() === 0) {
        throw new Exception('No rows updated (maybe already ' . $status . ')');
    }
    echo json_encode([
        'success' => true,
        'message' => "Status changed to {$status}!"
    ]);
    exit;
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
    exit;
} ?>