<?php
session_start();
require_once 'config.php';
header('Content-Type: application/json');

if (empty($_SESSION['id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}
if (isset($_SESSION['is_mini_superadmin']) && (int)$_SESSION['is_mini_superadmin'] === 1) {
    echo json_encode(['status' => 'error', 'message' => 'Permission denied']);
    exit;
}
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
    exit;
}
$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
if ($id <= 0) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid id']);
    exit;
}

$perm_add_school = isset($_POST['permission_add_school']) ? ((int)$_POST['permission_add_school'] ? 1 : 0) : 0;
$perm_create_admin = isset($_POST['permission_create_admin']) ? ((int)$_POST['permission_create_admin'] ? 1 : 0) : 0;
$perm_view_activity = isset($_POST['permission_view_activity']) ? ((int)$_POST['permission_view_activity'] ? 1 : 0) : 0;
$perm_create_mini = isset($_POST['permission_create_mini']) ? ((int)$_POST['permission_create_mini'] ? 1 : 0) : 0;

try {
    $check = $pdo->prepare("SELECT id, is_mini_superadmin FROM superadmin WHERE id = ? LIMIT 1");
    $check->execute([$id]);
    $row = $check->fetch();
    if (!$row) {
        echo json_encode(['status' => 'error', 'message' => 'Mini account not found']);
        exit;
    }
    if ((int)$row['is_mini_superadmin'] !== 1) {
        echo json_encode(['status' => 'error', 'message' => 'Target account is not a mini account']);
        exit;
    }
    $stmt = $pdo->prepare("UPDATE superadmin SET permission_add_school = ?, permission_create_admin = ?, permission_view_activity = ?, permission_create_mini = ? WHERE id = ?");
    $stmt->execute([$perm_add_school, $perm_create_admin, $perm_view_activity, $perm_create_mini, $id]);

    echo json_encode(['status' => 'success', 'message' => 'Permissions updated']);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Server error']);
} ?>