<?php
session_start();
require 'config.php';   

$adminId = isset($_SESSION["id"]) ? $_SESSION["id"] : null;
$adminSchool = isset($_SESSION["school"]) ? $_SESSION["school"] : null;

$SUPERADMIN_EMAIL = 'support@yourschooldomain.com';

$stmt = $pdo->prepare("SELECT id FROM listed_school WHERE school = :school LIMIT 1");
$stmt->execute([':school' => $adminSchool]);
$schoolId = $stmt->fetch();

$adminSchoolId = $schoolId['id'];

$admin = null;
if ($adminId) {
    $stmt = $pdo->prepare("SELECT id, name, email FROM teachers WHERE id = :id LIMIT 1");
    $stmt->execute([':id' => $adminId]);
    $admin = $stmt->fetch(PDO::FETCH_ASSOC) ?: null;
}

$school = null;
if ($adminSchoolId) {
    $stmt = $pdo->prepare("SELECT id, school, is_active FROM listed_school WHERE id = :id LIMIT 1");
    $stmt->execute([':id' => $adminSchoolId]);
    $school = $stmt->fetch(PDO::FETCH_ASSOC) ?: null;
}

$schoolStatus = 'unknown';
if ($school && isset($school['is_active'])) {
    $schoolStatus = strtolower(trim((string)$school['is_active']));
}

function h($s) { return htmlspecialchars((string)$s, ENT_QUOTES, 'utf-8'); }

$mailto_subject = rawurlencode("Request: Reactivation / Clarification (admin_id={$adminId}, school_id={$adminSchoolId})");
$mailto_body = rawurlencode("Hello Superadmin,\n\nMy account/school requires clarification. Please see details below:\n\n- Admin ID: {$adminId}\n- Admin name: " . ($admin['name'] ?? '-') . "\n- School ID: {$adminSchoolId}\n- School name: " . ($school['school'] ?? '-') . "\n\nReason / message:\n\n(Describe the issue here)\n\nThanks,\nAdmin");

$schoolInactive = ($schoolStatus === 'inactive' || $schoolStatus === '0' || $schoolStatus === 'false') && $school; ?>

<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Access restricted — Contact Superadmin</title>
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <link rel="shortcut icon" type="image/png" href="images/favicon.png">
    <style>
        :root{
        --brand-primary: #4D44B5;
        --brand-accent:  #FB7D5B;
        --muted:         #E6EBEE;
        }
        body {
        background: linear-gradient(180deg, #fbfbfe 0%, #f7f8fc 100%);
        min-height: 100vh;
        font-family: "Inter", system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
        color: #1f2d3d;
        padding: 36px 16px;
        }
        .panel {
        max-width: 980px;
        margin: 22px auto;
        background: white;
        border-radius: 14px;
        box-shadow: 0 10px 40px rgba(77,68,181,0.08);
        overflow: hidden;
        }
        .panel-head {
        background: linear-gradient(90deg, rgba(77,68,181,0.06), rgba(251,125,91,0.03));
        padding: 28px 32px;
        display:flex;
        gap:18px;
        align-items:center;
        }
        .brand-badge {
        width:72px;height:72px;border-radius:14px;
        display:grid;place-items:center;
        background: linear-gradient(135deg, var(--brand-primary), #6b61df);
        color: #fff; font-weight:700; font-size:22px;
        box-shadow: 0 6px 24px rgba(77,68,181,0.12);
        }
        .panel-head h1 { margin:0; font-size:20px; color:var(--brand-primary); }
        .panel-head p { margin:0; color:#42525a; opacity:0.9; }

        .panel-body { padding: 28px 32px; display:flex; gap:28px; flex-wrap:wrap; align-items:flex-start; }
        .status-card {
        flex: 1 1 320px;
        border-radius: 12px;
        padding: 18px;
        background: linear-gradient(180deg, #ffffff, var(--muted));
        box-shadow: 0 6px 20px rgba(34,41,47,0.03);
        border: 1px solid rgba(15,20,35,0.03);
        }
        .status-title { display:flex; gap:12px; align-items:center; font-weight:700; margin-bottom:8px; }
        .status-desc { color: #51606a; margin-bottom:12px; font-size:0.96rem; }

        .danger {
        border-left: 4px solid rgba(251,125,91,0.95);
        box-shadow: 0 6px 18px rgba(251,125,91,0.06);
        }
        .muted {
        color:#7a8892;
        }

        .cta-row { display:flex; gap:12px; margin-top:12px; }
        .btn-brand {
        background: linear-gradient(90deg,var(--brand-primary), #6b61df);
        border: none; color: #fff; padding:10px 16px; border-radius:10px; font-weight:600;
        display:inline-flex; gap:8px; align-items:center;
        }
        .btn-outline {
        background:transparent; border:1px solid rgba(77,68,181,0.12); color:var(--brand-primary);
        padding:10px 14px; border-radius:10px; font-weight:600;
        }
        .small-note { font-size:0.9rem; color:#6b7780; margin-top:8px; }
        .muted-pill { padding:6px 10px; background:#f5f7fb; border-radius:999px; color:#53606a; font-weight:600; font-size:0.92rem; }

        /* responsive */
        @media (max-width:760px) {
        .panel-head { padding:18px; gap:12px; }
        .panel-body { padding:16px; gap:16px; }
        }

        /* subtle animated icon */
        .pulse {
        width:44px;height:44px;border-radius:8px; display:grid;place-items:center;
        background: linear-gradient(180deg, #fff, rgba(77,68,181,0.03));
        box-shadow: 0 8px 30px rgba(77,68,181,0.06);
        animation: pulse 2s infinite;
        }
        @keyframes pulse {
        0%{ transform: translateY(0); }
        50%{ transform: translateY(-6px); }
        100%{ transform: translateY(0); }
        }
    </style>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"/>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
    <script src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
</head>
<body>
  <div class="panel" role="main" aria-labelledby="panelTitle">
    <div class="panel-head">
      <div class="brand-badge">SCH</div>
      <div>
        <h1 id="panelTitle">Access Restricted</h1>
        <p>Your access is currently restricted. This page tells you why and how to contact the superadmin for reactivation.</p>
      </div>
    </div>
    <div class="panel-body">
      <!-- Left column: Status cards -->
      <div style="flex:1 1 800px; min-width:280px;">
        <?php if ($schoolInactive): ?>
          <div class="status-card danger" aria-live="polite">
            <div class="status-title">
              <div class="pulse" aria-hidden>
                <svg width="22" height="22" viewBox="0 0 24 24" fill="none"><path d="M12 2L2 7l10 5 10-5-10-5z" fill="#FB7D5B"/></svg>
              </div>
              <div>
                <div style="font-size:1.05rem;">School disabled</div>
                <div class="muted-pill" style="margin-top:6px;"><?= h($school['school'] ?? 'Unnamed school') ?></div>
              </div>
            </div>
            <p class="status-desc">
              The school account for <strong><?= h($school['school'] ?? 'this school') ?></strong> has been disabled by the superadmin.
              While disabled, all school-level features are blocked and admins for this school cannot access the system.
            </p>
            <div class="small-note">Why this might happen:</div>
            <ul class="muted" style="margin-top:6px;">
              <li>Policy or billing issues</li>
              <li>Security or compliance reasons</li>
              <li>Manual deactivation by the superadmin</li>
            </ul>

            <div class="cta-row">
              <a class="btn-brand" id="contactSuper" href="mailto:<?= h($SUPERADMIN_EMAIL) ?>?subject=<?= $mailto_subject ?>&body=<?= $mailto_body ?>">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" style="filter:drop-shadow(0 1px 0 rgba(0,0,0,0.04));"><path d="M2 6v12h20V6L12 11 2 6z" fill="#fff"/></svg>
                Contact Superadmin
              </a>
              <a class="btn-outline" id="btnLogout" href="signout.php">Log out</a>
            </div>
          </div>
        <?php endif; ?>
        <?php if (!$schoolInactive): ?>
          <div class="status-card" aria-live="polite">
            <div class="status-title">
              <div style="width:44px;height:44px;border-radius:8px;display:grid;place-items:center;background:linear-gradient(90deg,var(--brand-accent), #ff8e69); color:#fff;">
                <svg width="18" height="18" viewBox="0 0 24 24" fill="none"><path d="M20 6L9 17l-5-5" stroke="#fff" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/></svg>
              </div>
              <div>
                <div style="font-size:1.05rem;">Access OK</div>
                <div class="muted-pill" style="margin-top:6px;">You have active access</div>
              </div>
            </div>
            <p class="status-desc">Both your admin account and school are active. Click the button below to continue to the dashboard.</p>
            <div class="cta-row">
              <a class="btn-brand" href="dashboard.php"><svg width="14" height="14" viewBox="0 0 20 20" fill="none"><path d="M10 2v6h6" stroke="#fff" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/></svg> Go to Dashboard</a>
            </div>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <script>
    function copyAdminInfo() {
      const text = 'Admin ID: <?= h($adminId ?: '-') ?>\\nSchool ID: <?= h($adminSchoolId ?: '-') ?>\\nAdmin: <?= h($admin['name'] ?? '-') ?>\\nSchool: <?= h($school['school'] ?? '-') ?>';
      if (navigator.clipboard && navigator.clipboard.writeText) {
        navigator.clipboard.writeText(text).then(function(){ toast('Copied admin info'); }, function(){ toast('Copy failed', true); });
      } else {
        const ta = document.createElement('textarea');
        ta.value = text; document.body.appendChild(ta); ta.select();
        try { document.execCommand('copy'); document.body.removeChild(ta); toast('Copied admin info'); }
        catch(e){ document.body.removeChild(ta); toast('Copy failed', true); }
      }
    }
    function toast(text, isError) {
      Toastify({
        text: text,
        duration: 2400,
        gravity: "top",
        position: "center",
        close: true,
        style: { background: isError ? "linear-gradient(90deg,#e63946,#b00020)" : "linear-gradient(90deg,#4D44B5,#6b61df)" }
      }).showToast();
    }
    document.getElementById('contactSuper')?.addEventListener('click', function(){ toast('Opening mail client...'); });
    document.getElementById('contactSuper2')?.addEventListener('click', function(){ toast('Opening mail client...'); });
    document.getElementById('btnLogout')?.addEventListener('click', function(){ toast('Signing out...'); });
  </script>
</body>
</html>