<?php
header('Content-Type: application/json');
require_once 'config.php'; 

try {
    function respond($status, $message = '') {
        echo json_encode(['status'=>$status, 'message'=>$message]);
        exit;
    }
    $fields = ['name','email','password','school'];
    foreach($fields as $f){
        if(empty($_POST[$f])) {
            respond('error', ucfirst($f).' is required');
        }
    }

    $school   = trim($_POST['school']);
    $name     = trim($_POST['name']);
    $phone    = trim($_POST['phone'] ?? '');
    $email    = trim($_POST['email']);
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $address  = trim($_POST['address'] ?? '');
    $univ     = trim($_POST['university'] ?? '');
    $college  = trim($_POST['college'] ?? '');
    $degree   = trim($_POST['degree'] ?? '');
    $duration = trim($_POST['duration'] ?? '');
    $city     = trim($_POST['city'] ?? '');
    $status   = 'active';

    $uploadDir = '../Admin/uploads/teacher';
    if(!is_dir($uploadDir)){
        mkdir($uploadDir, 0777, true);
        chmod($uploadDir, 0777);
    }

    $imagePath = '';
    if(isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK){
        $tmp  = $_FILES['image']['tmp_name'];
        $nameImg = basename($_FILES['image']['name']);
        $target = $uploadDir . '/' . time() . '_' . preg_replace('/[^A-Za-z0-9_\-\.]/', '_', $nameImg);
        if(move_uploaded_file($tmp, $target)){
            $imagePath = 'uploads/teacher/' . basename($target);
        } else {
            respond('error', 'Failed to move uploaded file.');
        }
    }

    $sql = "INSERT INTO teachers (name, phone, email, password, address, status, university, college, degree, duration, city, image, school) VALUES (:name, :phone, :email, :password, :address, :status, :univ, :college, :degree, :duration, :city, :image, :school)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':name'     => $name,
        ':phone'    => $phone,
        ':email'    => $email,
        ':password' => $password,
        ':address'  => $address,
        ':status'   => $status,
        ':univ'     => $univ,
        ':college'  => $college,
        ':degree'   => $degree,
        ':duration' => $duration,
        ':city'     => $city,
        ':image'    => $imagePath,
        ':school'   => $school
    ]);

    respond('success');
} catch (PDOException $e) {
    respond('error', 'DB Error: ' . $e->getMessage());
} ?>