<?php
require 'config.php';
header('Content-Type: application/json');
session_start();

$data = json_decode(file_get_contents('php://input'), true);
$id   = (int)($data['id'] ?? 0);
if (!$id) {
    echo json_encode(['success'=>false,'message'=>'Invalid ID']);
    exit;
}

try {
  $stmt = $pdo->prepare("DELETE FROM class_exams WHERE id = :id");
  $stmt->execute(['id'=>$id]);
  echo json_encode(['success'=>true,'message'=>'Exam deleted']);
} catch(PDOException $e) {
  error_log("DeleteExam Error: ".$e->getMessage());
  echo json_encode(['success'=>false,'message'=>'DB error']);
} ?>