<?php
session_start();
header('Content-Type: application/json; charset=utf-8');
if (empty($_SESSION['id'])) { echo json_encode(['status'=>false,'message'=>'Not authenticated']); exit; }
$adminId = intval($_SESSION['id']);

include 'config.php';

function json($ok,$msg){ echo json_encode(['status'=>$ok,'message'=>$msg]); exit; }

if ($_SERVER['REQUEST_METHOD'] !== 'POST') json(false,'Invalid request');

$current = $_POST['current_password'] ?? '';
$new = $_POST['new_password'] ?? '';
$confirm = $_POST['confirm_password'] ?? '';

if (!$current || !$new || !$confirm) json(false,'All fields are required');
if ($new !== $confirm) json(false,'Passwords do not match');

try {
    $stmt = $pdo->prepare("SELECT password FROM teachers WHERE id = :id LIMIT 1");
    $stmt->execute([':id'=>$adminId]);
    $row = $stmt->fetch();
    if (!$row) json(false,'User not found');

    if (!password_verify($current, $row['password'])) {
        json(false,'Existing password is incorrect');
    }

    $newhash = password_hash($new, PASSWORD_DEFAULT);
    $upd = $pdo->prepare("UPDATE teachers SET password = :pw WHERE id = :id LIMIT 1");
    $upd->execute([':pw'=>$newhash, ':id'=>$adminId]);

    json(true, 'Password changed successfully');
} catch (PDOException $e) {
    json(false, 'Server error: '.$e->getMessage());
} ?>