<?php
header('Content-Type:application/json');
session_start();
require 'config.php';

if (empty($_SESSION['id'])) {
    echo json_encode(['status'=>'error','message'=>'Unauthorized']);
    exit;
}

$id = intval($_POST['id'] ?? 0);
$title = trim($_POST['title'] ?? '');
$desc = trim($_POST['description'] ?? '');
$status = $_POST['status'] ?? '';

if(!$id || !$title || !$desc || !in_array($status,['Highpriority','Upcoming'])){
  echo json_encode(['status'=>'error','message'=>'Invalid data']); exit;
}

$prov = '';
$uploadDir = '../api/uploads/docs/';
if (!is_dir($uploadDir)) mkdir($uploadDir,0755,true);
if (!empty($_FILES['prov_doc']['name']) && $_FILES['prov_doc']['error'] === UPLOAD_ERR_OK) {
  $fn = time().'_'.basename($_FILES['prov_doc']['name']);
  if(move_uploaded_file($_FILES['prov_doc']['tmp_name'],$uploadDir.$fn)){
    $prov = '/api/uploads/docs/'.$fn;
  }
}

try {
  $sql = "UPDATE student_notice SET title=:t,description=:d,status=:s".($prov?" ,prov_doc=:p":"")." WHERE id=:id AND teacher_id=:tid";
  $stmt = $pdo->prepare($sql);
  $params=[':t'=>$title,':d'=>$desc,':s'=>$status,':id'=>$id,':tid'=>$_SESSION['id']];
  if($prov) $params[':p']=$prov;
  $stmt->execute($params);
  echo json_encode(['status'=>'success','message'=>'Notice updated']);
} catch(PDOException $e) {
  echo json_encode(['status'=>'error','message'=>'DB Error: '.$e->getMessage()]);
} ?>