<?php
header('Content-Type: application/json');
require 'config.php';

$school_id = isset($_GET['school_id']) ? (int)$_GET['school_id'] : 0;
if (!$school_id) {
    echo json_encode([]);
    exit;
}

try {
    $stmt = $pdo->prepare("SELECT id, name FROM departments WHERE school_id = ? ORDER BY name");
    $stmt->execute([$school_id]);
    echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
} catch (PDOException $e) {
    error_log("get_departments Error: " . $e->getMessage());
    echo json_encode([]);
} ?>