<?php
$adminId = isset($_SESSION["id"]) ? $_SESSION["id"] : null;
$adminName = isset($_SESSION["name"]) ? $_SESSION["name"] : null;
$adminEmail = isset($_SESSION["email"]) ? $_SESSION["email"] : null;
$adminSchool = isset($_SESSION["school"]) ? $_SESSION["school"] : null;
$adminPosition = isset($_SESSION["position"]) ? $_SESSION["position"] : null;

$stmt = $pdo->prepare("SELECT id, token, is_active FROM listed_school WHERE school = :school LIMIT 1");
$stmt->execute([':school' => $adminSchool]);
$schoolRow  = $stmt->fetch();

$adminSchoolId = $schoolRow ['id'];
$adminSchoolToken = $schoolRow ['token'];

$stmt = $pdo->prepare("SELECT image FROM teachers WHERE id = ? LIMIT 1");
$stmt->execute([$adminId]);
$teacherImage = $stmt->fetch(PDO::FETCH_ASSOC); 


$schoolStatus = 'active'; 
if ($schoolRow && isset($schoolRow['is_active'])) { $schoolStatus = strtolower(trim((string)$schoolRow['is_active'])); }

$inactiveValues = ['inactive', '0', 'false', 'disabled'];
if (in_array($schoolStatus, $inactiveValues, true)) {
    $target = 'access_blocked.php';
    if (!headers_sent()) {
        header('Location: ' . $target);
        exit;
    }
    echo '<script>window.location.href="' . addslashes($target) . '";</script>';
    exit;
} ?>

<ul class="navbar-nav header-right">
    <li class="nav-item">
        <div class="header-profile2">
            <a class="nav-link ms-0" href="teacher_profile.php?id=<?= base64_encode($adminId)?>">
                <div class="header-info2 d-flex align-items-center">
                    <div class="d-flex align-items-center sidebar-info"></div>
                    <?php if(!empty($teacherImage['image'])) { ?>
                    <img src="../Admin/<?= htmlspecialchars($teacherImage['image']) ?>" alt="Profile Picture">
                    <?php } else { ?>
                    <img src="images/user.jpg" alt="Profile Picture">
                    <?php } ?>
                </div>
            </a>
        </div>
    </li>
</ul>


<script>
    (function() {
        function pushLog() {
            try {
            var payload = {
                page_url: window.location.href,
                page_path: window.location.pathname + (window.location.search || ''),
                page_title: document.title || '',
                referrer: document.referrer || '',
                user_agent: navigator.userAgent
            };
            var url = 'log_activity.php';

            var body = JSON.stringify(payload);
            var headers = { type: 'application/json' };

            if (navigator.sendBeacon) {
                var blob = new Blob([body], { type: 'application/json' });
                navigator.sendBeacon(url, blob);
                return;
            }

            fetch(url, {
                method: 'POST',
                body: body,
                credentials: 'same-origin',
                headers: { 'Content-Type': 'application/json' },
                keepalive: true
            }).catch(function(){  });
            } catch(e) {
                console && console.debug && console.debug('log push failed', e);
            }
        }

        if (document.readyState === 'complete' || document.readyState === 'interactive') {
            setTimeout(pushLog, 250);
        } else {
            document.addEventListener('DOMContentLoaded', function(){ setTimeout(pushLog, 250); });
        }
    })();
</script>