<?php
require 'config.php';
session_start();

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['ok'=>false, 'msg'=>'Method not allowed']);
    exit;
}
if (empty($_SESSION['id'])) {
    http_response_code(401);
    echo json_encode(['ok'=>false,'msg'=>'Not authenticated']);
    exit;
}

$raw = file_get_contents('php://input');
$data = json_decode($raw, true);
if (!is_array($data)) $data = [];

// Helper: get client IP
function getClientIP() {
    $keys = ['HTTP_CLIENT_IP','HTTP_X_FORWARDED_FOR','HTTP_X_FORWARDED','HTTP_X_CLUSTER_CLIENT_IP','HTTP_FORWARDED_FOR','HTTP_FORWARDED','REMOTE_ADDR'];
    foreach ($keys as $k) {
        if (!empty($_SERVER[$k])) {
            $ip = $_SERVER[$k];
            if (strpos($ip, ',') !== false) {
                $parts = explode(',', $ip);
                $ip = trim($parts[0]);
            }
            return $ip;
        }
    }
    return null;
}

$userId   = isset($_SESSION['id']) ? (int) $_SESSION['id'] : null;
$userName = $_SESSION['name']  ?? null;
$userEmail= $_SESSION['email'] ?? null;
$schoolSession  = $_SESSION['school'] ?? null;
$position = $_SESSION['position'] ?? 'Teacher';

$schoolId = null; $schoolName = null; $schoolToken = null;
if ($schoolSession !== null) {
    if (ctype_digit((string)$schoolSession)) {
        $stmt = $pdo->prepare("SELECT id, school, token FROM listed_school WHERE id = :id LIMIT 1");
        $stmt->execute([':id' => (int)$schoolSession]);
    } else {
        $stmt = $pdo->prepare("SELECT id, school, token FROM listed_school WHERE school = :s LIMIT 1");
        $stmt->execute([':s' => $schoolSession]);
    }
    $sr = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($sr) {
        $schoolId = $sr['id'];
        $schoolName = $sr['school'];
        $schoolToken = $sr['token'];
    }
}

$page_url   = isset($data['page_url']) ? trim((string)$data['page_url']) : null;
$page_path  = isset($data['page_path']) ? trim((string)$data['page_path']) : null;
$page_title = isset($data['page_title']) ? trim((string)$data['page_title']) : null;
$referrer   = isset($data['referrer']) ? trim((string)$data['referrer']) : null;
$userAgent  = $_SERVER['HTTP_USER_AGENT'] ?? ($data['user_agent'] ?? null);

if ($page_path && strlen($page_path) > 255) $page_path = substr($page_path, 0, 255);
if ($page_title && strlen($page_title) > 255) $page_title = substr($page_title, 0, 255);
if ($userAgent && strlen($userAgent) > 2000) $userAgent = substr($userAgent, 0, 2000);

$ip = getClientIP();

$userRole = 'teacher';

try {
    $sql = "INSERT INTO user_activity_logs
        (user_id, user_name, user_email, user_role, teacher_position, school_id, school_name, school_token, page_url, page_path, page_title, referrer, user_agent, ip_address)
        VALUES
        (:user_id, :user_name, :user_email, :user_role, :teacher_position, :school_id, :school_name, :school_token, :page_url, :page_path, :page_title, :referrer, :user_agent, :ip_address)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':user_id' => $userId,
        ':user_name' => $userName,
        ':user_email' => $userEmail,
        ':user_role' => $userRole,
        ':teacher_position' => $position,
        ':school_id' => $schoolId,
        ':school_name' => $schoolName,
        ':school_token' => $schoolToken,
        ':page_url' => $page_url,
        ':page_path' => $page_path,
        ':page_title' => $page_title,
        ':referrer' => $referrer,
        ':user_agent' => $userAgent,
        ':ip_address' => $ip
    ]);
    echo json_encode(['ok' => true]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'msg' => 'DB error']);
} ?>