<?php
header('Content-Type: application/json');
session_start();
require 'config.php';

if (empty($_SESSION['id'])) {
    echo json_encode(['status'=>'error','message'=>'Not logged in']);
    exit;
}

$studentId  = (int)($_POST['student_id'] ?? 0);
$title      = trim($_POST['title'] ?? '');
$description= trim($_POST['description'] ?? '');
$created_at = date('Y-m-d H:i:s');

if (!$studentId || !$title || !$description) {
    echo json_encode(['status'=>'error','message'=>'All fields except document are required']);
    exit;
}

$prov_doc_path = '';
$uploadDir = '../api/uploads/reports/';
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}
if (!empty($_FILES['prov_doc']['name']) && $_FILES['prov_doc']['error'] === UPLOAD_ERR_OK) {
    $fname = time() . '_' . basename($_FILES['prov_doc']['name']);
    $target = $uploadDir . $fname;
    if (move_uploaded_file($_FILES['prov_doc']['tmp_name'], $target)) {
        $prov_doc_path = '/api/uploads/reports/' . $fname;
    }
}

try {
    $stmt = $pdo->prepare("
        INSERT INTO student_reports (created_at, title, description, prov_doc, student_id) VALUES (:created_at, :title, :description, :prov_doc, :student_id)");
    $stmt->execute([':created_at' => $created_at, ':title' => $title, ':description'=> $description, ':prov_doc' => $prov_doc_path, ':student_id' => $studentId]);

    echo json_encode(['status'=>'success','message'=>'Report submitted']);

} catch (PDOException $e) {
    echo json_encode([
        'status'=>'error',
        'message'=>'DB Error: ' . $e->getMessage()
    ]);
} ?>