<?php
header('Content-Type: application/json');
require 'config.php';
session_start();
try {
    $id   = (int)($_POST['id'] ?? 0);
    $pos  = trim($_POST['position'] ?? '');
    if(!$id || !$pos){
        throw new Exception('Invalid payload');
    }

    $u = $pdo->prepare("UPDATE teachers SET position=:pos WHERE id=:id");
    $u->execute([':pos'=>$pos,':id'=>$id]);

    if($pos==='Class Teacher') {
        $dept = (int)($_POST['department_id'] ?? 0);
        $cls  = (int)($_POST['class_id'] ?? 0);
        $sec  = $_POST['section_id']!=='' ? (int)$_POST['section_id'] : null;
        if(!$dept||!$cls) throw new Exception('Dept & Class required');
        $del = $pdo->prepare("DELETE FROM assigned_class_teacher WHERE teacher_id=?");
        $del->execute([$id]);
        $ins = $pdo->prepare("INSERT INTO assigned_class_teacher (teacher_id,department_id,class_id,section_id) VALUES (:t,:d,:c,:s)");
        $ins->execute([
          ':t'=>$id,':d'=>$dept,':c'=>$cls,':s'=>$sec
        ]);
    } else {
        $del = $pdo->prepare("DELETE FROM assigned_class_teacher WHERE teacher_id=?");
        $del->execute([$id]);
    }
    echo json_encode(['status'=>'success']);

} catch(Exception $e){
    echo json_encode(['status'=>'error','message'=>$e->getMessage()]);
} ?>