<?php
header('Content-Type: application/json');
session_start();
require 'config.php';

if (empty($_SESSION['id'])) {
  echo json_encode(['status'=>'error','message'=>'Not logged in']);
  exit;
}

$appId = intval($_POST['app_id'] ?? 0);
if (!$appId || !isset($_FILES['prove_doc'])) {
  echo json_encode(['status'=>'error','message'=>'Invalid request']);
  exit;
}

$uploadDir = '../api/uploads/leave/';
if (!is_dir($uploadDir)) mkdir($uploadDir, 0755, true);

$file = $_FILES['prove_doc'];
if ($file['error'] !== UPLOAD_ERR_OK) {
  echo json_encode(['status'=>'error','message'=>'File upload error']);
  exit;
}

$filename   = time() . '_' . basename($file['name']);
$targetPath = $uploadDir . $filename;
if (!move_uploaded_file($file['tmp_name'], $targetPath)) {
  echo json_encode(['status'=>'error','message'=>'Failed to move file']);
  exit;
}

$publicPath = 'api/uploads/leave/' . $filename;

try {
  $stmt = $pdo->prepare("UPDATE teacher_posted_application SET prove_doc = :doc  WHERE id = :id AND teacher_id = :tid");
  $stmt->execute([':doc' => $publicPath, ':id'  => $appId, ':tid' => $_SESSION['id']]);

  echo json_encode(['status'=>'success']);
} catch (PDOException $e) {
  echo json_encode([
    'status' => 'error',
    'message'=> 'DB Error: ' . $e->getMessage()
  ]);
} ?>