<?php
require 'config.php';
header('Content-Type:application/json');
session_start();

$exam_id    = (int)($_POST['exam_id']    ?? 0);
$student_id = (int)($_POST['student_id'] ?? 0);
$marks_raw  = $_POST['marks']           ?? [];

if (!$exam_id || !$student_id || !is_array($marks_raw)) {
    echo json_encode(['success'=>false,'message'=>'Invalid input']);
    exit;
}

$stmt = $pdo->prepare("SELECT total_marks, subjects FROM class_exams WHERE id = ? LIMIT 1");
$stmt->execute([$exam_id]);
$exam = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$exam) {
    echo json_encode(['success'=>false,'message'=>'Exam not found']);
    exit;
}
$max = (int)$exam['total_marks'];
$subjects = json_decode($exam['subjects'], true) ?: [];

$validated = [];
foreach ($subjects as $sub) {
    $key = preg_replace('/\s+/', '_', strtolower($sub));
    if (!isset($marks_raw[$key])) {
        echo json_encode(['success'=>false,'message'=>"Missing mark for {$sub}"]);
        exit;
    }
    $m = (int)$marks_raw[$key];
    if ($m < 0 || $m > $max) {
        echo json_encode(['success'=>false,'message'=>"Invalid mark for {$sub}"]);
        exit;
    }
    $validated[$sub] = $m;
}

try {
    $jsonMarks = json_encode($validated);
    $stmt = $pdo->prepare("INSERT INTO student_results (exam_id, student_id, marks) VALUES (:exam, :stud, :marks)");
    $stmt->execute(['exam'  => $exam_id, 'stud'  => $student_id, 'marks' => $jsonMarks]);
    echo json_encode(['success'=>true,'message'=>'Marks uploaded']);
} catch (PDOException $e) {
    error_log("UploadMarks Error: ".$e->getMessage());
    echo json_encode(['success'=>false,'message'=>'Database error']);
} ?>