<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');

$responseData = [];

if (empty($_GET['teacher_id']))
{
    echo json_encode([
        'status' => false,
        'data' => $responseData
    ]);
    exit();
}

$teacher_id = trim($_GET['teacher_id']);
$student_id = !empty($_GET['student_id']) && isset($_GET['student_id']) ? trim($_GET['student_id']) : null;

include "configDealer.php";
$booksSql = "SELECT id, name, author, des AS book_des, image AS book_image FROM books ORDER BY name";
$booksResult = mysqli_query($conn, $booksSql);

$books = [];
while ($row = mysqli_fetch_assoc($booksResult)) {
    $books[] = $row;
}

$copiesSql = "SELECT book_id, code_image, status, copy_code FROM book_copies";
$copiesResult = mysqli_query($conn, $copiesSql);

$copiesByBook = [];
while ($row = mysqli_fetch_assoc($copiesResult)) {
    $copiesByBook[$row['book_id']][] = [
        'code_image' => $row['code_image'],
        'book_id' => $row['copy_code'],
        'status' => $row['status']
    ];
}

foreach ($books as $book) {
    $bookId = $book['id'];
    $qr_images = [];
    $qr_count = 0;
    $book_codes = [];

    if (isset($copiesByBook[$bookId])) {
        foreach ($copiesByBook[$bookId] as $copy) {
            $qr_images[] = "https://project.conocimientoinfotech.com/Kolkata_Dealer/Admin/" . $copy['code_image'];
            $book_codes[] = $copy['book_id'];
            if ($copy['status'] === "available") {
                $qr_count++;
            }
        }
    }
    
    $responseData[] = [
        'id' => $bookId,
        'name' => $book['name'],
        'author' => $book['author'],
        'description' => $book['book_des'],
        'image' => "https://project.conocimientoinfotech.com/Kolkata_Dealer/Admin/" . $book['book_image'],
        'qr_codes' => $qr_images,
        'stock_quantity' => $qr_count,
        'book_id' => $book_codes
    ];
}


echo json_encode([
    'status' => true,
    'data' => $responseData
]);

mysqli_close($conn);
?>
