<?php
// ini_set('display_errors', 1);
// error_reporting(E_ALL);
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');

include 'configDealer.php';

$response = [];

if (empty($_GET['teacher_id'])) {
    $response['status'] = false;
    $response['message'] = "Missing required parameter: teacher_id";
    echo json_encode($response);
    exit();
}

$teacher_id = mysqli_real_escape_string($conn, trim($_GET['teacher_id']));

$data = [];

$get_letter_q = "
    SELECT * FROM teacher_in_class_currently WHERE teacher_id = '{$teacher_id}' AND DATE(clock_in_time) = CURRENT_DATE AND (clock_out_time IS NULL OR clock_out_time = '') ORDER BY id DESC LIMIT 1";

$get_letter_r = mysqli_query($conn, $get_letter_q);

if ($get_letter_r && mysqli_num_rows($get_letter_r) > 0) {
    while ($row = mysqli_fetch_assoc($get_letter_r)) {
        $get_stu_q = "SELECT * FROM class_qr_codes WHERE qr_code = '{$row['class_code']}'";
        $get_stu_r = mysqli_query($conn, $get_stu_q);
        $get_stu_a = mysqli_fetch_array($get_stu_r);
        
        $get_class_q = "SELECT name FROM departments WHERE id = '{$get_stu_a['department_id']}'";
        $get_class_r = mysqli_query($conn, $get_class_q);
        $get_class_a = mysqli_fetch_array($get_class_r);
        
        $get_dept_q = "SELECT name FROM classes WHERE id = '{$get_stu_a['class_id']}'";
        $get_dept_r = mysqli_query($conn, $get_dept_q);
        $get_dept_a = mysqli_fetch_array($get_dept_r);
        
        $get_sec_q = "SELECT name FROM sections WHERE id = '{$get_stu_a['section_id']}'";
        $get_sec_r = mysqli_query($conn, $get_sec_q);
        $get_sec_a = mysqli_fetch_array($get_sec_r);
        
        $data[] = [
            'clock_in_time' => $row['clock_in_time'],
            'dept_name' => $get_dept_a['name'],
            'class_name' => $get_class_a['name'],
            'section_name' => $get_sec_a['name']
        ];
    }

    $response['status'] = true;
    $response['message'] = "Teacher currently in a class";
    $response['data'] = $data;
} else {
    $response['status'] = false;
    $response['message'] = "Teacher not in class";
}

echo json_encode($response, JSON_PRETTY_PRINT);

mysqli_close($conn);
?>
