<?php
// header('Content-Type: application/json');
// header('Access-Control-Allow-Origin: *');
// header('Access-Control-Allow-Methods: GET');
// header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');

// include 'configDealer.php';

// $response = [];

// // Validate teacher_id parameter
// if (empty($_GET['teacher_id'])) {
//     $response['status'] = false;
//     $response['message'] = "Missing required parameter: teacher_id";
//     echo json_encode($response);
//     exit();
// }

// $teacher_id = mysqli_real_escape_string($conn, trim($_GET['teacher_id']));

// // Fetch all assignments for the teacher
// $get_assignments_q = "SELECT * FROM routine_assignments WHERE teacher_id = '{$teacher_id}'";
// $get_assignments_r = mysqli_query($conn, $get_assignments_q);

// if ($get_assignments_r && mysqli_num_rows($get_assignments_r) > 0) {
//     $routine = [];

//     while ($assignment = mysqli_fetch_assoc($get_assignments_r)) {
//         $slot_id = $assignment['slot_id'];
//         $subject = $assignment['subject'];

//         // Get details of the routine and slot
//         $get_slot_q = "
//             SELECT 
//                 r.id AS routine_id,
//                 r.department_id,
//                 r.class_id,
//                 r.section_id,
//                 r.school_start,
//                 r.period_duration,
//                 r.tiffin_break_duration,
//                 r.slots_before_tiffin,
//                 r.slots_after_tiffin,
//                 r.weekdays_count,
//                 r.created_at AS routine_created_at,
//                 rs.id AS slot_id,
//                 rs.weekday,
//                 rs.slot_order,
//                 rs.start_time,
//                 rs.end_time,
//                 rs.is_tiffin_break
//             FROM 
//                 routines r
//             LEFT JOIN 
//                 routine_slots rs ON rs.routine_id = r.id
//             WHERE 
//                 rs.id = '{$slot_id}'
//         ";
//         $get_slot_r = mysqli_query($conn, $get_slot_q);

//         if ($get_slot_r && mysqli_num_rows($get_slot_r) > 0) {
//             $slot = mysqli_fetch_assoc($get_slot_r);

//             $day = $slot['weekday'];
//             if (!isset($routine[$day])) {
//                 $routine[$day] = [
//                     'weekday' => $day,
//                     'slots' => []
//                 ];
//             }
            
//             // foreach($slot as $slots)
//             // {
//             //     $get_dept_class_sec_q = "SELECT 
//             //                                 d.id AS dept_id,
//             //                                 d.name AS dept_name,
//             //                                 c.id AS class_id,
//             //                                 c.name AS class_name,
//             //                                 s.id AS section_id,
//             //                                 s.name AS section_name
//             //                             FROM 
//             //                                 departments d
//             //                             LEFT JOIN 
//             //                                 classes c ON c.department_id = d.id
//             //                             LEFT JOIN 
//             //                                 sections s ON s.class_id = c.id
//             //                                 WHERE d.id = '{$slot['department_id']}' AND c.id = '{$slot['class_id']}' AND s.id = '{$slot['section_id']}'
//             //                           ";
                
//             //     $get_dept_class_sec_r = mysqli_query($conn, $get_dept_class_sec_q);
                
//             // }

//             $routine[$day]['slots'][] = [
//                 'slot_id' => (int)$slot['slot_id'],
//                 'start_time' => $slot['start_time'],
//                 'end_time' => $slot['end_time'],
//                 'subject' => $subject,
//                 'is_tiffin_break' => (bool)$slot['is_tiffin_break']
//             ];
//         }
//     }

//     // Sort weekdays (optional)
//     $weekdays_order = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
//     $sorted_routine = [];
//     foreach ($weekdays_order as $day) {
//         if (isset($routine[$day])) {
//             $sorted_routine[] = $routine[$day];
//         }
//     }

//     $response['status'] = true;
//     $response['data'] = $sorted_routine;
// } else {
//     $response['status'] = false;
//     $response['message'] = "No routine assignments found for the given teacher_id.";
// }

// echo json_encode($response, JSON_PRETTY_PRINT);

// mysqli_close($conn);

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');

include 'configDealer.php';

$response = [];

// Validate teacher_id parameter
if (empty($_GET['teacher_id'])) {
    $response['status'] = false;
    $response['message'] = "Missing required parameter: teacher_id";
    echo json_encode($response);
    exit();
}

$teacher_id = mysqli_real_escape_string($conn, trim($_GET['teacher_id']));

// Fetch all assignments for the teacher
$get_assignments_q = "SELECT * FROM routine_assignments WHERE teacher_id = '{$teacher_id}'";
$get_assignments_r = mysqli_query($conn, $get_assignments_q);

if ($get_assignments_r && mysqli_num_rows($get_assignments_r) > 0) {
    $routine = [];

    while ($assignment = mysqli_fetch_assoc($get_assignments_r)) {
        $slot_id = $assignment['slot_id'];
        $subject = $assignment['subject'];

        // Get details of the routine and slot including dept, class, section names
        $get_slot_q = "
            SELECT 
                r.id AS routine_id,
                r.school_start,
                r.period_duration,
                r.tiffin_break_duration,
                r.slots_before_tiffin,
                r.slots_after_tiffin,
                r.weekdays_count,
                rs.id AS slot_id,
                rs.weekday,
                rs.slot_order,
                rs.start_time,
                rs.end_time,
                rs.is_tiffin_break,
                d.name AS dept_name,
                c.name AS class_name,
                s.name AS section_name
            FROM 
                routines r
            LEFT JOIN 
                routine_slots rs ON rs.routine_id = r.id
            LEFT JOIN 
                departments d ON r.department_id = d.id
            LEFT JOIN 
                classes c ON r.class_id = c.id
            LEFT JOIN 
                sections s ON r.section_id = s.id
            WHERE 
                rs.id = '{$slot_id}'
        ";
        $get_slot_r = mysqli_query($conn, $get_slot_q);

        if ($get_slot_r && mysqli_num_rows($get_slot_r) > 0) {
            $slot = mysqli_fetch_assoc($get_slot_r);

            $day = $slot['weekday'];
            if (!isset($routine[$day])) {
                $routine[$day] = [
                    'weekday' => $day,
                    'slots' => []
                ];
            }

            $routine[$day]['slots'][] = [
                'slot_id' => (int)$slot['slot_id'],
                'start_time' => $slot['start_time'],
                'end_time' => $slot['end_time'],
                'subject' => $subject,
                'is_tiffin_break' => (bool)$slot['is_tiffin_break'],
                'dept_name' => $slot['dept_name'],
                'class_name' => $slot['class_name'],
                'section_name' => $slot['section_name']
            ];
        }
    }

    // Sort weekdays (optional)
    $weekdays_order = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
    $sorted_routine = [];
    foreach ($weekdays_order as $day) {
        if (isset($routine[$day])) {
            $sorted_routine[] = $routine[$day];
        }
    }

    $response['status'] = true;
    $response['data'] = $sorted_routine;
} else {
    $response['status'] = false;
    $response['message'] = "No routine assignments found for the given teacher_id.";
}

echo json_encode($response, JSON_PRETTY_PRINT);

mysqli_close($conn);

?>
