<?php
// ini_set('display_errors', 1);
// error_reporting(E_ALL);
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');

include 'configDealer.php';

$response = [];

if (empty($_GET['teacher_id'])) {
    $response['status'] = false;
    $response['message'] = "Missing required parameter: teacher_id";
    echo json_encode($response);
    exit();
}

$teacher_id = mysqli_real_escape_string($conn, trim($_GET['teacher_id']));
$student_uid = !empty($_GET['student_uid'])?mysqli_real_escape_string($conn, trim($_GET['student_uid'])) : null;

$data = [];

if (empty($student_uid))
{
    $get_letter_q = "
        SELECT 
            *
        FROM 
            student_assigned_books 
        WHERE (actual_submit_date IS NULL OR actual_submit_date = '')
        ORDER BY 
            id DESC
    ";
}
else
{
    $get_st_id_q = "SELECT * FROM students_temp WHERE student_uid = '{$student_uid}'";
    $get_st_id_r = mysqli_query($conn, $get_st_id_q);
    if (mysqli_num_rows($get_st_id_r) == 0)
    {
        echo json_encode(array("status" => false, "message" => "Student not found"));
        mysqli_close($conn);
        exit();
    }
    $get_st_id_a = mysqli_fetch_array($get_st_id_r);
    $get_st_id = $get_st_id_a['id'];
    $get_st_name = $get_st_id_a['name'];
    $get_st_image = $get_st_id_a['image'];
    $get_st_roll = $get_st_id_a['roll_no'];
    $get_st_class = $get_st_id_a['class_id'];
    $get_st_dept = $get_st_id_a['department_id'];
    $get_st_sec = $get_st_id_a['section_id'];
    
    if (!empty($get_st_class) && !empty($get_st_dept))
    {
        $get_sec_name_a = mysqli_fetch_array(mysqli_query($conn, "SELECT name FROM sections WHERE id = '{$get_st_sec}'"));
        $get_sec_name = $get_sec_name_a['name'];
        
        $get_class_name_r = mysqli_query($conn, "SELECT name FROM departments WHERE id = '{$get_st_dept}'");
        $get_class_name_a = mysqli_fetch_array($get_class_name_r);
        $get_class_name = $get_class_name_a['name'];
        
        $get_dept_name_a = mysqli_fetch_array(mysqli_query($conn, "SELECT name FROM classes WHERE id = '{$get_st_class}'"));
        $get_dept_name = $get_dept_name_a['name'];
    }
    
    $get_letter_q = "
        SELECT 
            *
        FROM 
            student_assigned_books 
        WHERE student_id = '{$get_st_id}' AND (actual_submit_date IS NULL OR actual_submit_date = '')
        ORDER BY 
            id DESC
    ";
}

$get_letter_r = mysqli_query($conn, $get_letter_q);

if ($get_letter_r && mysqli_num_rows($get_letter_r) > 0) {
    while ($row = mysqli_fetch_assoc($get_letter_r)) {
        $book_id = (string)$row['book_id'];
        $get_book_info_q = "SELECT b.* FROM books b LEFT JOIN book_copies bc ON b.id = bc.book_id WHERE bc.copy_code = '$book_id'";
        $get_book_info_r = mysqli_query($conn, $get_book_info_q);
        if (mysqli_num_rows($get_book_info_r) == 0)
        {
            $book_name = null;
            $author = null;
            $image = null;
            $des = null;
        }
        else
        {
            $get_book_info_a = mysqli_fetch_array($get_book_info_r);
            $book_name = $get_book_info_a['name'];
            $author = $get_book_info_a['author'];
            $image = "https://project.conocimientoinfotech.com/Kolkata_Dealer/Admin/".$get_book_info_a['image'];
            $des = $get_book_info_a['des'];
        }
        
        if (empty($student_uid))
        {
            $get_st_id_q = "SELECT * FROM students_temp WHERE id = '{$row['student_id']}'";
            $get_st_id_r = mysqli_query($conn, $get_st_id_q);
            if (mysqli_num_rows($get_st_id_r) == 0)
            {
                echo json_encode(array("status" => false, "message" => "Student not found"));
                mysqli_close($conn);
                exit();
            }
            $get_st_id_a = mysqli_fetch_array($get_st_id_r);
            $get_st_id = $get_st_id_a['id'];
            $get_st_name = $get_st_id_a['name'];
            $get_st_uid = $get_st_id_a['student_uid'];
            $get_st_image = $get_st_id_a['image'];
            $get_st_roll = $get_st_id_a['roll_no'];
            $get_st_class = $get_st_id_a['class_id'];
            $get_st_dept = $get_st_id_a['department_id'];
            $get_st_sec = $get_st_id_a['section_id'];
            
            if (!empty($get_st_class) && !empty($get_st_dept))
            {
                $get_sec_name_a = mysqli_fetch_array(mysqli_query($conn, "SELECT name FROM sections WHERE id = '{$get_st_sec}'"));
                $get_sec_name = $get_sec_name_a['name'];
                
                $get_class_name_r = mysqli_query($conn, "SELECT name FROM departments WHERE id = '{$get_st_dept}'");
                $get_class_name_a = mysqli_fetch_array($get_class_name_r);
                $get_class_name = $get_class_name_a['name'];
                
                $get_dept_name_a = mysqli_fetch_array(mysqli_query($conn, "SELECT name FROM classes WHERE id = '{$get_st_class}'"));
                $get_dept_name = $get_dept_name_a['name'];
            }
        }
        $data[] = [
            'id' => $row['id'],
            'book_id' => $row['book_id'],
            'pickup_date' => !empty($row['pickup_date']) ? date("Y-m-d", strtotime($row['pickup_date'])) : null,
            'supposed_submit_date' => !empty($row['supposed_submit_date']) ? date("Y-m-d", strtotime($row['supposed_submit_date'])) : null,
            'actual_submit_date' => !empty($row['actual_submit_date']) ? date("Y-m-d", strtotime($row['actual_submit_date'])) : null,
            'student_name' => $get_st_name,
            'student_roll' => $get_st_roll,
            'student_uid' => !empty($student_uid) ? $student_uid : $get_st_uid,
            'student_image' => !empty($get_st_image) ? "https://project.conocimientoinfotech.com/Kolkata_Dealer/Student/" . $get_st_image : null,
            'dept_name' => $get_dept_name,
            'class_name' => $get_class_name,
            'section_name' => $get_sec_name,
            'book_name' => $book_name,
            'book_author' => $author,
            'book_image' => $image,
            'book_des' => $des,
        ];

    }

    $response['status'] = true;
    $response['message'] = "Borrowed books fetched successfully";
    $response['data'] = $data;
} else {
    $response['status'] = false;
    $response['message'] = "No borrowed found.";
}

echo json_encode($response, JSON_PRETTY_PRINT);

mysqli_close($conn);
?>
