<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');

include 'configDealer.php';

$response = [];

if (empty($_GET['dept_id']) || empty($_GET['class_id'])) {
    $response['status'] = false;
    $response['message'] = "Input parameters 'dept_id' and 'class_id' are required.";
    echo json_encode($response);
    exit();
}

$dept_id = mysqli_real_escape_string($conn, trim($_GET['dept_id']));
$class_id = mysqli_real_escape_string($conn, trim($_GET['class_id']));
$section_id = !empty($_GET['section_id']) ? mysqli_real_escape_string($conn, trim($_GET['section_id'])) : null;

// Build query dynamically based on section_id
$que = "
    SELECT 
        *
    FROM 
        students_temp
    WHERE 
        department_id = '{$dept_id}' 
        AND class_id = '{$class_id}'
";

if ($section_id !== null) {
    $que .= " AND section_id = '{$section_id}'";
}

$res = mysqli_query($conn, $que);

if ($res && mysqli_num_rows($res) > 0) {
    $students = [];
    while ($row = mysqli_fetch_assoc($res)) {
        $students[] = [
            'student_id' => $row['id'],
            'student_name' => $row['name'],
            'roll_number' => $row['roll_no'],
            'guardian_name' => $row['guardian_name'],
            'department_id' => $row['department_id'],
            'class_id' => $row['class_id'],
            'section_id' => $row['section_id'] !== null ? $row['section_id'] : null
        ];
    }

    $response['status'] = true;
    $response['data'] = $students;
} else {
    $response['status'] = false;
    $response['message'] = "No students found for the given parameters.";
}

echo json_encode($response);

mysqli_close($conn);
?>
