<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');

include "configDealer.php"; 

$studentId = (int)($_REQUEST['student_id']);

if (!$studentId) {
    echo json_encode(['status' => 'error', 'message' => 'student_id is required']);
    exit;
}

// Query reports for this student
$sql = "SELECT 
            r.id AS report_id,
            r.title,
            r.description,
            r.prov_doc,
            r.created_at,
            s.id AS student_id,
            s.name AS student_name,
            s.roll_no,
            s.dob,
            s.age,
            s.email,
            s.phone,
            s.image,
            d.name AS department,
            c.name AS class,
            sec.name AS section
        FROM student_reports r
        JOIN students_temp s ON r.student_id = s.id
        JOIN departments d ON d.id = s.department_id
        JOIN classes c ON c.id = s.class_id
        LEFT JOIN sections sec ON sec.id = s.section_id
        WHERE s.id = ?
        ORDER BY r.created_at DESC";

$stmt = mysqli_prepare($conn, $sql);
if (!$stmt) {
    echo json_encode(['status'=>'error','message'=>'Query prepare failed: '.mysqli_error($conn)]);
    exit;
}

mysqli_stmt_bind_param($stmt, "i", $studentId);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$reports = [];
while ($row = mysqli_fetch_assoc($result)) {
    $reports[] = [
        'report_id'    => (int)$row['report_id'],
        'title'        => $row['title'],
        'description'  => $row['description'],
        'prov_doc'     => $row['prov_doc'] ? "https://project.conocimientoinfotech.com/Kolkata_Dealer/Admin/".$row['prov_doc'] : null,
        'created_at'   => $row['created_at'],
        'student' => [
            'id'        => (int)$row['student_id'],
            'name'      => $row['student_name'],
            'roll_no'   => $row['roll_no'],
            'dob'       => $row['dob'],
            'age'       => $row['age'],
            'email'     => $row['email'],
            'phone'     => $row['phone'],
            'image'     => $row['image'] ? "https://project.conocimientoinfotech.com/Kolkata_Dealer/Admin/".$row['image'] : null,
            'department'=> $row['department'],
            'class'     => $row['class'],
            'section'   => $row['section'] ?: '-'
        ]
    ];
}

mysqli_stmt_close($stmt);
mysqli_close($conn);

if (empty($reports)) {
    echo json_encode(['status'=>'error','message'=>'No reports found for this student']);
} else {
    echo json_encode(['status'=>'success','data'=>$reports]);
}
?>
