<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');

$student_id = (!empty($_GET['student_id'])) ? $_GET['student_id'] : null;
$exam_id = (!empty($_GET['exam_id'])) ? $_GET['exam_id'] : null;
$output = [];

if (empty($student_id) || empty($exam_id)) {
    echo json_encode([
        'status' => false,
        'exam_results' => $output,
        'message' => 'Missing student_id or exam_id'
    ]);
    exit();
}

include '../configDealer.php';

$get_exam_q = "SELECT marks FROM student_results WHERE student_id = '{$student_id}' AND exam_id = '{$exam_id}'";
$get_exam_r = mysqli_query($conn, $get_exam_q);

if ($get_exam_r && mysqli_num_rows($get_exam_r) > 0) {
    while ($row = mysqli_fetch_assoc($get_exam_r)) {
        if (!empty($row['marks'])) {
            $decoded_marks = json_decode($row['marks'], true);
            $row['marks'] = is_array($decoded_marks) ? $decoded_marks : ['error' => 'Invalid marks format'];
        } else {
            $row['marks'] = [];
        }
        $output[] = $row;
    }

    echo json_encode([
        'status' => true,
        'exam_results' => $output
    ]);
} else {
    echo json_encode([
        'status' => false,
        'exam_results' => $output,
        'message' => 'No results found for this student and exam'
    ]);
}

mysqli_close($conn);
?>
